/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */


package net.xfra.qizxopen.xquery.fn;
import net.xfra.qizxopen.xquery.impl.*;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;

/**
 *  Implementation of function fn:doc.
 */
public class Doc extends Function {

    static Prototype[] protos = { 
        Prototype.fn("doc", Type.DOCUMENT.opt, Exec.class)
            .arg("uri", Type.STRING.opt)
    };

    public Prototype[] getProtos() { return protos; }

    public static class Exec extends Function.Call {

        public Value eval(Focus focus, EvalContext context)
	    throws XQueryException {
	    Value uriv = args[0].eval( focus, context );
	    context.at(this);
	    if(!uriv.next())
		return Value.empty;
	    String uri = uriv.asString();
	    try {
		return context.getDocument( uri );
	    }
	    catch (EvalException err) {
		//TODO: return document { <?error ...?> }
		return context.error(this, err);
	    }
        }

	public int getFlags() {
	    return DOCUMENT_ORDER + SAME_DEPTH + WITHIN_SUBTREE;
	}
    }
}
