/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.fn;
import net.xfra.qizxopen.xquery.impl.*;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;

/**
 *  Implementation of function fn:error.
 */
public class Error extends Function {

    static Prototype[] protos = { 
        Prototype.fn("error", Type.NONE, Exec.class),
        Prototype.fn("error", Type.NONE, Exec.class) .arg("srcval", Type.ITEM.opt)
    };

    public Prototype[] getProtos() { return protos; }

    public static class Exec extends Function.Call {

        public Value eval(Focus focus, EvalContext context) throws XQueryException {
            context.at(this);
	    String msg = args.length == 0 ? "error" : args[0].evalAsString(focus, context);
	    return context.error(this, msg);
        }
    }
}
