/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */


package net.xfra.qizxopen.xquery.fn;
import net.xfra.qizxopen.xquery.impl.*;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dm.Node;

/**
 *  Implementation of function fn:get-namespace-uri-for-prefix.
 */
public class GetNamespaceUriForPrefix extends Function {

    static Prototype[] protos = { 
        Prototype.fn("get-namespace-uri-for-prefix", Type.STRING.opt, Exec.class)
            .arg("prefix", Type.STRING)
            .arg("element", Type.ELEMENT)
    };
    public Prototype[] getProtos() { return protos; }

    public static class Exec extends Function.OptStringCall {

        public String evalAsOptString(Focus focus, EvalContext context) throws XQueryException {
            context.at(this);
	    String prefix = args[0].evalAsString(focus, context);
	    Node element = args[1].evalAsOptNode(focus, context);
	    return element.getNsUri(prefix);
        }
    }
}
