/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */


package net.xfra.qizxopen.xquery.fn;
import net.xfra.qizxopen.xquery.impl.*;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dt.MomentValue;
import net.xfra.qizxopen.xquery.dt.DurationValue;

/**
 *  Implementation of function fn:get-seconds.
 */
public class GetSeconds extends Function {

    static Prototype[] protos = { 
      Prototype.fn("get-seconds", Type.DOUBLE.opt, Exec.class).arg("op", Type.DURATION.opt)
    };
    public Prototype[] getProtos() { return protos; }

    public static class Exec extends Function.DoubleCall {
        public double evalAsDouble(Focus focus, EvalContext context) throws XQueryException {
            context.at(this);
	    Item v = args[0].evalAsOptItem(focus, context);
	    if(v == null)
		throw EmptyException.allowed();
	    DurationValue dv = (DurationValue) v;	
	    return dv.getValue().getSeconds();
        }
    }
}
