/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.fn;
import net.xfra.qizxopen.xquery.impl.*;

import net.xfra.qizxopen.util.time.*;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dt.MomentValue;
import net.xfra.qizxopen.xquery.dt.DurationValue;

/**
 *  Implementation of function fn:get-seconds-from-time.
 */
public class GetSecondsFromTime extends Function {

    static Prototype[] protos = { 
      Prototype.fn("get-seconds-from-time", Type.DOUBLE.opt, Exec.class).arg("op", Type.TIME.opt)
    };
    public Prototype[] getProtos() { return protos; }

    public static class Exec extends Function.DoubleCall {
        public double evalAsDouble(Focus focus, EvalContext context) throws XQueryException {
            context.at(this);
	    Item v = args[0].evalAsOptItem(focus, context);
	    if(v == null)
		throw EmptyException.allowed();
	    if(v instanceof MomentValue) {
		MomentValue mv = (MomentValue) v;
		return mv.getValue().getSecond();
	    }
	    try {
		Time dt = Time.parseTime( v.asString(), context.getImplicitTimezone() );
		return dt.getSecond();
	    }
	    catch(DateTimeException e) {
		context.error(this, "cannot cast to xs:time : "+ e.getMessage()); return 0;
	    }
        }
    }
}

