/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */


package net.xfra.qizxopen.xquery.fn;
import net.xfra.qizxopen.xquery.impl.*;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dt.IntegerValue;
import java.text.Collator;

/**
 *  Implementation of function fn:index-of.
 */
public class IndexOf extends Function {

    static Prototype[] protos = { 
        Prototype.fn("index-of", Type.INTEGER.star, Exec.class)
            .arg("seqParam", Type.ANY_ATOMIC_TYPE.star)
            .arg("srchParam", Type.ANY_ATOMIC_TYPE),
        Prototype.fn("index-of", Type.INTEGER.star, Exec.class)
            .arg("seqParam", Type.ANY_ATOMIC_TYPE.star)
            .arg("srchParam", Type.ANY_ATOMIC_TYPE)
            .arg("collationLiteral", Type.STRING)
    };

    public Prototype[] getProtos() { return protos; }

    public static class Exec extends Function.Call {

        public Value eval(Focus focus, EvalContext context) throws XQueryException {
	    Value src = args[0].eval(focus, context);
	    Item item = args[1].evalAsItem(focus, context);
	    Collator collator = args.length < 3 ? 
		null : context.getCollator(args[2].evalAsString(focus, context));
            context.at(this);
	    return new Sequence(src, item, collator, context.getImplicitTimezone());
        }
    }

    static class Sequence  extends IntegerValue {

	Value source;
	Item searched;
	int position = 0;
	Collator collator;
	int timezone;

	Sequence( Value source, Item searched, Collator collator, int timezone ) {
	    this.source = source;
	    this.searched = searched;
	    this.collator = collator;
	    this.timezone = timezone;
	}

	public boolean next() throws XQueryException {
	    for(; source.next(); ) {
		++ position;
		if(source.compareTo(searched, collator, timezone) == 0)
		    return true;
	    }
	    return false;
	}

	public long   asInteger() throws TypeException {
	    return position;
	}

	public Value  bornAgain() {
	    return new Sequence( source, searched, collator, timezone );
	}
    }
}
