/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */


package net.xfra.qizxopen.xquery.fn;
import net.xfra.qizxopen.xquery.impl.*;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dm.*;

/**
 *  Implementation of function fn:lang.
 */
public class Lang extends Function {

    static Prototype[] protos = { 
        Prototype.fn("lang", Type.BOOLEAN, Exec.class) .arg("testlang", Type.STRING)
    };
    public Prototype[] getProtos() { return protos; }

    public static class Exec extends Function.BoolCall {

        public boolean evalAsBoolean(Focus focus, EvalContext context) throws XQueryException {
            context.at(this);
	    String arg = args[0].evalAsString(focus, context);
	    QName lang = QName.get(Namespace.XML, "lang");
	    Item dot = focus.getItem();
	    if(dot == null || !dot.isNode())
		return false;
	    for( Node node = dot.asNode() ; node != null; node = node.getParent()) {
		Node attr = node.getAttribute(lang);
		if(attr == null)
		    continue;
		return attr.getStringValue().equals(arg);
	    }
	    return false;
        }
    }
}
