/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */


package net.xfra.qizxopen.xquery.fn;
import net.xfra.qizxopen.xquery.impl.*;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
//import net.xfra.qizxopen.xquery.dm.*;

/**
 *  Implementation of function fn:lower-case.
 */
public class LowerCase extends Function {

    static Prototype[] protos = { 
        Prototype.fn("lower-case", Type.STRING.opt, Exec.class)
            .arg("srcval", Type.STRING.opt)
    };
    public Prototype[] getProtos() { return protos; }

    public static class Exec extends Function.OptStringCall {

        public String evalAsOptString(Focus focus, EvalContext context) throws XQueryException {
	    String s1 = args[0].evalAsOptString(focus, context);
            context.at(this);
	    if(s1 == null)
		return "";	// Nov2003 // null;
	    return s1.toLowerCase();
        }
    }
}
