/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.fn;

import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.op.StringLiteral;
import net.xfra.qizxopen.xquery.op.Expression;

import java.util.regex.*;

/**
 *  Implementation of function fn:matches.
 */
public class Matches extends Function {

    static Prototype[] protos = { 
        Prototype.fn("matches", Type.BOOLEAN.opt, Exec.class)
            .arg("input", Type.STRING.opt)
            .arg("pattern", Type.STRING),
        Prototype.fn("matches", Type.BOOLEAN.opt, Exec.class)
            .arg("input", Type.STRING.opt)
            .arg("pattern", Type.STRING)
            .arg("flags", Type.STRING)
    };

    public Prototype[] getProtos() { return protos; }

    public static int convertFlags( String flags ) {
	int cflags = Pattern.UNIX_LINES;
	for(int i = flags.length(); --i >= 0; )
	    if(flags.charAt(i) == 'm')
		cflags |= Pattern.MULTILINE;
	    else if(flags.charAt(i) == 'i')
		cflags |= Pattern.CASE_INSENSITIVE | Pattern.UNICODE_CASE;
	    else if(flags.charAt(i) == 's')	// Nov 2003
		cflags |= Pattern.DOTALL;
	    else if(flags.charAt(i) == 'x')	// Nov 2003
		cflags |= Pattern.COMMENTS;
	    else return -1;
	return cflags;
    }

    public static Pattern precompileRegexp( Expression patternx, Expression flagsx,
					    boolean allowEmptyMatch ) {
	if(patternx instanceof StringLiteral && 
	   (flagsx == null || flagsx instanceof StringLiteral)) {
	    try {
		String pattern = ((StringLiteral) patternx).value, flags = "";
		if(flagsx != null)
		    flags = ((StringLiteral) flagsx).value;
		int cflags = convertFlags(flags);
		if(cflags < 0)
		    return null;	// delay to runtime
		Pattern pat = Pattern.compile(pattern, cflags);
		if(!allowEmptyMatch && pat.matcher("").matches()) 
		    return null;	// delay to runtime
		return pat;
	    }
	    catch(PatternSyntaxException e) { }	// delay to runtime
	}
	return null;
    }

    // run-time: 
    public static Pattern compileRegexp( Expression patternExp, Expression flagsExp,
					 boolean allowEmptyMatch,
					 Focus focus, EvalContext context )
	throws XQueryException {
	String regexp = patternExp.evalAsString(focus, context);
	String sflags = flagsExp == null ? "" : flagsExp.evalAsString(focus, context);
	int cflags = convertFlags(sflags);
	if(cflags < 0)
	    context.error(flagsExp, "illegal regular expression flags");
	try {
	    Pattern pattern = Pattern.compile(regexp, cflags);
	    if(!allowEmptyMatch && pattern.matcher("").matches()) 
		context.error(patternExp, "pattern matches empty string");
	    return pattern;
	}
	catch (PatternSyntaxException e) {
	    context.error(patternExp, "invalid regular expression: "+ e.getMessage());
	}
	return null;
    }

    public static class Exec extends Function.BoolCall {

	Pattern precompiled = null;
	// precompile regexp if constant
	public void compilationHook() {
	    Expression xflags = args.length < 3 ? null : args[2];
	    precompiled = precompileRegexp(args[1], xflags, true);
	}

	public Pattern preparedPattern( EvalContext context ) throws XQueryException {
	    Expression xflags = args.length < 3 ? null : args[2];
	    return precompiled != null ? precompiled
		: compileRegexp(args[1], xflags, true, null, context);
	}

        public boolean evalAsBoolean(Focus focus, EvalContext context)
	    throws XQueryException {
	    String input = args[0].evalAsOptString(focus, context);
	    if(input == null)
		input = "";
            context.at(this);

	    Pattern pat = preparedPattern(context);
	    Matcher mat = pat.matcher(input);
	    return mat.find();
        }
    }
}
