/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */


package net.xfra.qizxopen.xquery.fn;
import net.xfra.qizxopen.xquery.impl.*;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dm.Node;
import net.xfra.qizxopen.xquery.dt.SingleQName;

/**
 *  Implementation of function fn:node-name.
 */
public class NodeName extends Function {

    static Prototype[] protos = { 
        Prototype.fn("node-name", Type.QNAME.opt, Exec.class),
        Prototype.fn("node-name", Type.QNAME.opt, Exec.class)
            .arg("srcval", Type.NODE)
    };

    public Prototype[] getProtos() { return protos; }

    public static class Exec extends Function.Call {

        public Value eval(Focus focus, EvalContext context) throws XQueryException {
            context.at(this);
	    Node node = null;
	    if(args.length == 0) {
		if(focus == null || !focus.getItem().isNode())
		    context.error(this, "context item is not a node");
		node = focus.getItem().asNode();
	    }
	    else node = args[0].evalAsNode(focus, context);
	    QName qname = node.getNodeName();
	    return qname == null ? Value.empty : new SingleQName(qname);
        }
    }
}
