/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */


package net.xfra.qizxopen.xquery.fn;
import net.xfra.qizxopen.xquery.impl.*;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
//import net.xfra.qizxopen.xquery.dm.*;

/**
 *  Implementation of function fn:number.
 */
public class Number extends Function {

    static Prototype[] protos = { 
        Prototype.fn("number", Type.DOUBLE, Exec.class),
        Prototype.fn("number", Type.DOUBLE, Exec.class)
            .arg("srcval", Type.ITEM.opt)
    };

    public Prototype[] getProtos() { return protos; }

    public static class Exec extends Function.DoubleCall {

        public double evalAsDouble(Focus focus, EvalContext context) throws XQueryException {
            context.at(this);
	    if(args.length == 0) {
		if(focus == null || !focus.getItem().isNode())
		    return Double.NaN;
		return focus.getItem().asDouble();
	    }
	    else try {
		return args[0].evalAsOptDouble(focus, context);
	    } catch(EmptyException e) {
		return Double.NaN;
	    }
        }
    }

}
