/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */


package net.xfra.qizxopen.xquery.fn;
import net.xfra.qizxopen.xquery.impl.*;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
//import net.xfra.qizxopen.xquery.dm.*;

/**
 *  Implementation of function fn:remove.
 */
public class Remove extends Function {

    static Prototype[] protos = { 
        Prototype.fn("remove", Type.ITEM.star, Exec.class)
            .arg("target", Type.ITEM.star)
            .arg("position", Type.INTEGER)
    };

    public Prototype[] getProtos() { return protos; }


    public static class Exec extends Function.Call {

        public Value eval(Focus focus, EvalContext context) throws XQueryException {
            context.at(this);
            context.error(this, "not available: use $target[ position() ne $pos ]");
	    return Value.empty;
        }
    }
}
