/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */


package net.xfra.qizxopen.xquery.fn;
import net.xfra.qizxopen.xquery.impl.*;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dm.Node;
import net.xfra.qizxopen.xquery.dt.SingleNode;

/**
 *  Implementation of function fn:root.
 */
public class Root extends Function {

    static Prototype[] protos = { 
        Prototype.fn("root", Type.NODE, Exec.class),
        Prototype.fn("root", Type.NODE, Exec.class) .arg("arg", Type.NODE)
    };
    public Prototype[] getProtos() { return protos; }

    public static class Exec extends Function.Call {

        public Value eval(Focus focus, EvalContext context) throws XQueryException {
            context.at(this);
	    Node n = null;
	    if(args.length == 0) {
		checkFocus(focus, context);
		n = focus.getItem().asNode();
	    }
	    else {
		n = args[0].evalAsNode(focus, context);
		context.at(this);
	    }
	    return new SingleNode( n.getDocument() );
        }
    }
}
