/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.fn;
import net.xfra.qizxopen.xquery.impl.*;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;

/**
 *  Implementation of function fn:string-pad.
 */
public class StringPad extends Function {

    static Prototype[] protos = { 
        Prototype.fn("string-pad", Type.STRING.opt, Exec.class)
            .arg("padString", Type.STRING.opt)
            .arg("padCount", Type.INTEGER)
    };

    public Prototype[] getProtos() { return protos; }

    public static class Exec extends Function.OptStringCall {

        public String evalAsOptString(Focus focus, EvalContext context) throws XQueryException {
	    String padString = args[0].evalAsOptString(focus, context);
	    long padCount = args[1].evalAsInteger(focus, context);
	    if(padCount < 0) context.error(args[1], "invalid string-pad count");
            context.at(this);
	    StringBuffer buf = new StringBuffer();
	    for( ; --padCount >= 0; )
		buf.append(padString);
	    return buf.toString();
        }
    }
}
