/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */


package net.xfra.qizxopen.xquery.fn;
import net.xfra.qizxopen.xquery.impl.*;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.op.FilterExpr;

/**
 *  Implementation of function fn:subsequence.
 */
public class Subsequence extends Function {

    static Prototype[] protos = { 
        Prototype.fn("subsequence", Type.ITEM.star, Exec.class)
            .arg("sourceSeq", Type.ITEM.star)
            .arg("startingLoc", Type.DOUBLE),
        Prototype.fn("subsequence", Type.ITEM.star, Exec.class)
            .arg("sourceSeq", Type.ITEM.star)
            .arg("startingLoc", Type.DOUBLE)
            .arg("length", Type.DOUBLE)
    };

    public Prototype[] getProtos() { return protos; }

    public static class Exec extends Function.Call {

        public Value eval(Focus focus, EvalContext context) throws XQueryException {
            context.at(this);
            Value src = args[0].eval(focus, context);
	    int start = (int) args[1].evalAsDouble(focus, context), end = Integer.MAX_VALUE;
	    if(args.length == 3)
		end = start + (int) args[2].evalAsDouble(focus, context) - 1;
	    return new FilterExpr.Slice( src, start, end );
        }
    }
}
