/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */


package net.xfra.qizxopen.xquery.fn;
import net.xfra.qizxopen.xquery.impl.*;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
//import net.xfra.qizxopen.xquery.dm.*;

/**
 *  Implementation of function fn:translate.
 */
public class Translate extends Function {

    static Prototype[] protos = { 
        Prototype.fn("translate", Type.STRING.opt, Exec.class)
            .arg("srcval", Type.STRING.opt)
            .arg("mapString", Type.STRING.opt)
            .arg("transString", Type.STRING.opt)
    };

    public Prototype[] getProtos() { return protos; }

    final static int SURROGATE_INF = 0xd800, SURROGATE_SUP = 0xdfff;

    private static String translate( String src, String map, String trans )
	throws XQueryException {
	// simple optim: detect min and max of mapped chars
	int min = 0xffff, max = 0;
	for(int i = map.length(); --i >= 0; ) {
	    int c = map.charAt(i);
	    if(c < min) min = c;
	    if(c > max) max = c;
	    if(c >= SURROGATE_INF && c <= SURROGATE_SUP)
		throw new XQueryException("translation of surrogate pairs not supported");
	    // surrogate pairs in the source string dont harm: they are left untouched
	}

	StringBuffer buf = new StringBuffer();
	for(int i = 0, L = src.length(), index; i < L; i++) {
	    char c = src.charAt(i);
	    if(c >= min && c <= max && (index = map.indexOf(c)) >= 0)
		c = trans.charAt(index);
	    buf.append(c);
	}
	return buf.toString();
    }

    public static class Exec extends Function.OptStringCall {

        public String evalAsOptString(Focus focus, EvalContext context) throws XQueryException {
            context.at(this);
            String src = args[0].evalAsOptString(focus, context);
            String map = args[1].evalAsString(focus, context);
            String trans = args[2].evalAsString(focus, context);
	    if(src == null)
		return "";
	    return translate(src, map, trans);
        }
    }
}
