/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.fn;
import net.xfra.qizxopen.xquery.impl.*;

import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dt.SingleMoment;
import net.xfra.qizxopen.util.time.Date;
import net.xfra.qizxopen.util.time.DateTimeException;

/**
 *  Implementation of function xs:date.
 */
public class XS_date extends CastFunction {

    static Prototype[] protos = { 
	// for CastFunction
        Prototype.xs("date", Type.DATE, Exec.class) .arg("srcval", Type.ANY_ATOMIC_TYPE),
	// normal proto: not for CastFunction
        Prototype.xs("date", Type.DATE, ExecM.class)
	 .arg("year", Type.INTEGER).arg("month", Type.INTEGER).arg("day", Type.INTEGER)
    };

    public Prototype[] getProtos() { return protos; }

    public static class ExecM extends Function.Call {
        public Value eval(Focus focus, EvalContext context) throws XQueryException {
	    int year = (int) args[0].evalAsInteger(focus, context);
	    int month = (int) args[1].evalAsInteger(focus, context);
	    int day = (int) args[2].evalAsInteger(focus, context);
            context.at(this);
	    try {
		return new SingleMoment( new Date(year, month, day, 0, 0, 0), Type.DATE );
	    }
	    catch (DateTimeException e) {
		context.error(this, e.getMessage()); return Value.empty;
	    }
        }
    }
}
