/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */


package net.xfra.qizxopen.xquery.fn;
import net.xfra.qizxopen.xquery.impl.*;

import net.xfra.qizxopen.util.time.*;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dt.SingleMoment;

/**
 *  Implementation of function xs:dateTime.
 */
public class XS_dateTime extends CastFunction {

    static Prototype[] protos = { 
        Prototype.xs("dateTime", Type.DATE_TIME, Exec.class) .arg("srcval", Type.ATOM),
	// normal proto: not for CastFunction
        Prototype.xs("dateTime", Type.DATE_TIME, ExecM.class)
	.arg("year", Type.INTEGER).arg("month", Type.INTEGER).arg("day", Type.INTEGER)
	.arg("hours",Type.INTEGER).arg("minutes",Type.INTEGER).arg("seconds",Type.INTEGER),
        Prototype.xs("dateTime", Type.DATE_TIME, ExecM.class)
	.arg("year", Type.INTEGER).arg("month", Type.INTEGER).arg("day", Type.INTEGER)
	.arg("hours", Type.INTEGER).arg("minutes",Type.INTEGER).arg("seconds",Type.DOUBLE)
	.arg("timezone", Type.DOUBLE)
    };
    public Prototype[] getProtos() { return protos; }

    public static class ExecM extends Function.Call {
        public Value eval(Focus focus, EvalContext context) throws XQueryException {
	    int year = (int) args[0].evalAsInteger(focus, context);
	    int month = (int) args[1].evalAsInteger(focus, context);
	    int day = (int) args[2].evalAsInteger(focus, context);
	    int hour = (int) args[3].evalAsInteger(focus, context);
	    int minute = (int) args[4].evalAsInteger(focus, context);
	    double second = args[5].evalAsDouble(focus, context);
	    int tz = args.length > 6 ? (int) (args[6].evalAsDouble(focus, context) * 60)
		                     : context.getImplicitTimezone();

            context.at(this);
	    try {
		return new SingleMoment(
		    new DateTime( year, month, day, hour, minute, second,
				  tz < 0 ? -1 : 1, Math.abs(tz) / 60, Math.abs(tz) % 60),
		    Type.DATE_TIME );
	    }
	    catch (DateTimeException e) {
		context.error(this, e.getMessage()); return Value.empty;
	    }
        }
    }
}
