/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.fn;
import net.xfra.qizxopen.xquery.impl.*;

import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.util.time.*;
import net.xfra.qizxopen.xquery.dt.SingleDuration;

/**
 *  Implementation of function xs:duration.
 */
public class XS_duration extends CastFunction {

    static Prototype[] protos = { 
        Prototype.xs("duration", Type.DURATION, Exec.class)
	.arg("srcval", Type.ANY_ATOMIC_TYPE),
        Prototype.xs("duration", Type.DURATION, ExecMS.class)
	.arg("months", Type.INTEGER).arg("seconds", Type.DOUBLE)
    };
    public Prototype[] getProtos() { return protos; }

    public static class ExecMS extends Function.Call {
        public Value eval(Focus focus, EvalContext context) throws XQueryException {
	    long months = args[0].evalAsInteger(focus, context);
	    double seconds = args[1].evalAsDouble(focus, context);
            context.at(this);
	    return new SingleDuration( new Duration( (int) months, seconds) );
        }
    }
}
