/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.impl;

import net.xfra.qizxopen.dm.*;

import org.xml.sax.*;
import org.xml.sax.ext.LexicalHandler;

/**
 *  Wraps a Node as a XMLReader.
 *  The parse method traverses the node and generates SAX events.
 */
public class SAXSourceWrapper implements XMLReader
{
    static final String FEATURE_NS =
                    "http://xml.org/sax/features/namespaces";
    static final String FEATURE_NSPREFIXES =
                    "http://xml.org/sax/features/namespace-prefixes";
    static final String PROPERTY_LEXICAL =
                    "http://xml.org/sax/properties/lexical-handler";

    private SAXEventReceiver saxout = new SAXEventReceiver();
    private Node root;

    public SAXSourceWrapper(Node root) {
        this.root = root;
    }

    public ContentHandler getContentHandler() {
        return saxout.getContentHandler();
    }
    public void setContentHandler(ContentHandler handler) {
        saxout.setContentHandler(handler);
    }

    public DTDHandler getDTDHandler() {
        return null;
    }
    public void setDTDHandler(DTDHandler handler) { }

    public ErrorHandler getErrorHandler() {
        return saxout.getErrorHandler();
    }
    public void setErrorHandler(ErrorHandler handler) {
        saxout.setErrorHandler(handler);
    }

    public EntityResolver getEntityResolver() {
        return null;
    }
    public void setEntityResolver(EntityResolver resolver) { }

    public boolean getFeature(String name)
      throws SAXNotRecognizedException, SAXNotSupportedException {
        if(name.equals(FEATURE_NS))
            return true;
        else if(name.equals(FEATURE_NSPREFIXES)) {
            return saxout.nsPrefixes;
        }
        else {
            throw new SAXNotSupportedException(name);
        }
    }

    public void setFeature(String name, boolean value)
	    throws SAXNotRecognizedException, SAXNotSupportedException {
	
        if(name.equals(FEATURE_NS)) {
            if(!value) // cant help managing NS!
                throw new SAXNotSupportedException(name);
        }
        else if(name.equals(FEATURE_NSPREFIXES))
            saxout.nsPrefixes = value;
        else throw new SAXNotSupportedException(name);
    }

    public Object getProperty(String name)
	throws SAXNotRecognizedException, SAXNotSupportedException {
        if(name.equals(PROPERTY_LEXICAL))
            return saxout.getLexicalHandler();
        throw new SAXNotSupportedException(name);
    }
    
    public void setProperty(String name, Object value)
	        throws SAXNotRecognizedException, SAXNotSupportedException {
        if(name.equals(PROPERTY_LEXICAL))
            saxout.setLexicalHandler( (LexicalHandler) value );
        throw new SAXNotSupportedException(name);
    }    

    public void parse(InputSource inputSource) throws SAXException {
        exec();	// ignore input
    }

    public void parse( String systemId ) throws SAXException {
        exec();	// ignore input
    }

    private void exec() throws SAXException {
        try {
	    // dont obey Saxon!
	    saxout.nsPrefixes = true;

            saxout.traverse(root, false);
        }
        catch (DataModelException e) {
            throw new SAXException("traversal error", e);
        }
    }

} // end of class SAXSourceWrapper
