/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.dm.NodeTest;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dm.*;
import java.util.Vector;

/**
 *  Implementation of attribute:: (aka /@ ) step. 
 */
public class AttributeStep extends BasicStep {

    public AttributeStep( NodeTest nodeTest ) {
        super( nodeTest );
    }

    public void dump( ExprDump d ) {
	d.header( this, "AttributeStep" );
        d.display("nodeTest", nodeTest == null ? null : nodeTest.toString());
    }

    public Value eval( Focus focus, EvalContext context ) throws XQueryException {
	checkFocus(focus, context);
	return focus.getItem().asNode().getAttributes( nodeTest );
    }

    public int getFlags() {
	return DOCUMENT_ORDER + SAME_DEPTH + WITHIN_SUBTREE + WITHIN_NODE;
    }
}
