/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.dm.*;
import net.xfra.qizxopen.xquery.*;

/**
 *  Superclass of path steps. 
 */
public abstract class BasicStep extends Expression {

    public NodeTest  nodeTest;
    // for reverse axes: whether the step must be generated in natural step order
    // (ie reverse) or in document order.
    boolean naturalStepOrder = false;

    public BasicStep( NodeTest nodeTest ) {
        this.nodeTest = nodeTest;
    }

    public Expression child(int rank) {
	return null;
    }

    public Expression staticCheck( StaticContext context ) {
	type = Type.NODE.star;
	if(nodeTest != null)
	    switch( nodeTest.getNodeKind() ) {
		case Node.ELEMENT:
		    type = Type.ELEMENT.star; break;
		case Node.DOCUMENT:
		    type = Type.DOCUMENT.star; break;
		case Node.TEXT:
		    type = Type.TEXT.star; break;
		case Node.COMMENT:
		    type = Type.COMMENT.star; break;
		case Node.PROCESSING_INSTRUCTION:
		    type = Type.PI.star; break;
		case Node.ATTRIBUTE:
		    type = Type.ATTRIBUTE.star; break;
	    }	    
	return this;
    }
}
