/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dm.*;
import java.util.Vector;

/**
 *  Representation of a typeswitch case (or default) clause.
 */
public class CaseClause extends VarClause {

    public CaseClause( ) {
        super(null);
	varType = Type.ANY;
    }

    public void dump( ExprDump d ) {
	d.header( this, "CaseClause" );
        d.display("variable", variable);
        d.display("varAddress", varDecl != null? varDecl.address : -1);
        d.display("varType", varType);
        d.display("return", expr);
    }

    public Expression staticCheck( StaticContext context ) {
	LocalVariable mark = context.markLocalVariables();
	if(variable != null)
	    varDecl = context.defineLocalVariable(variable, varType, this);
	expr = context.staticCheck(expr, 0);
	if(variable != null)
	    context.popLocalVariables(mark);
	type = expr.getType();
	return this;
    }
}
