/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.fn.Function;
import net.xfra.qizxopen.xquery.fn.Prototype;

/**
 *  Superclass of all comparison operators. 
 * 
 */
public abstract class Comparison extends Expression {

    public Expression[]  operands;

    public Comparison( Expression expr1, Expression expr2 ) {
        operands = new Expression[] { expr1, expr2 };
    }

    public interface Test {
	// diff is -1 if lt, 0 if eq, 1 if gt
	boolean make( int diff );
	Test reverse();
	String getName();
    }

    protected abstract Prototype[] getProtos();
    protected abstract Test getTest();

    public Expression child(int rank) {
	return rank < 2 ? operands[rank] : null;
    }

    public Expression staticCheck( StaticContext context ) {
	operands[0] = context.staticCheck( operands[0], 0 );
	operands[1] = context.staticCheck( operands[1], 0 );
        Exec exec = (Exec) context.resolve( getProtos(), operands, this );
	exec.test = getTest();
	return exec;
    }

    public abstract static class Exec extends Function.BoolCall {
	public Test test;

	public boolean isEq() {
	    return test == ValueEqOp.TEST;
	}
    }

    public boolean evalAsEffectiveBoolean( Focus focus, EvalContext context )
	throws XQueryException{
	return evalAsBoolean(focus, context);
    }
}
