/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.dm.NodeTest;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dm.*;
import java.util.Vector;

/**
 *  Implementation of path step descendant-or-self:: aka //.
 */
public class DescendantOrSelfStep extends DescendantStep {

    public DescendantOrSelfStep( NodeTest nodeTest ) {
        super( nodeTest );
    }

    public void dump( ExprDump d ) {
	d.header( this, "descendant-or-self::" );
        d.display("nodeTest", nodeTest == null ? null : nodeTest.toString());
    }

    public Value eval( Focus focus, EvalContext context ) throws XQueryException {
	checkFocus(focus, context);
	return focus.getItem().asNode().getDescendantsOrSelf( nodeTest );
    }
}
