/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.util.QName;
import net.xfra.qizxopen.dm.XMLEventReceiver;
import net.xfra.qizxopen.dm.DataModelException;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dm.*;
import java.util.Vector;

/**
 *  class ElementConstructor: 
 * 
 */
public class ElementConstructor extends NamedConstructor {

    public Vector  attributes = new Vector();

    public ElementConstructor( Expression name ) {
        super( name );
    }

    public void  addAttribute( AttributeConstructor attribute ) {
        attributes.add(attribute);
    }

    public void putCharacters (char ch[], int start, int length) {
	addTextItem(new String(ch, start, length));
    }

    public AttributeConstructor  getAttribute( int rank ) {
        return rank < 0 || rank >= attributes.size() ? 
	    null : (AttributeConstructor) attributes.get(rank);
    }

    public void dump( ExprDump d ) {
	d.header(this, "element-constructor");
        d.display("name", name);
        d.display("attributes", attributes);
        d.display("contents", contents);
    }

    public Expression staticCheck( StaticContext context ) {
	super.staticCheck(context);
	for(int e = 0, E = attributes.size(); e < E; e++) {
	    attributes.set(e, context.staticCheck( getAttribute(e), 0 ));
	}
	type = Type.ELEMENT;
	return this;
    }

    public int getFlags() { // single Node: necessarily at same_depth!
	return DOCUMENT_ORDER + SAME_DEPTH;
    }

    public Node evalAsNode( Focus focus, EvalContext context ) throws XQueryException {
	// we arrive here if building nodes is really wanted
	EventDrivenBuilder builder = new EventDrivenBuilder();
	try {
	    evalAsEvents( builder, focus, context );
	    return builder.crop();
        }
        catch (DataModelException e) {
	    e.printStackTrace(); return null;// should not happen
	}
    }

    public void evalAsEvents( XMLEventReceiver output, Focus focus, EvalContext context )
	throws XQueryException, DataModelException {
	context.at(this);
        QName qname = evalName(output, focus, context);
	try {
	    output.startElement(qname);

	    for(int a = 0; a < attributes.size(); a++) {
		getAttribute(a).evalAsEvents(output, focus, context);
	    }
	    for(int c = 0; c < contents.length; c++) {
		contents[c].evalAsEvents(output, focus, context);
	    }	
	    output.endElement(qname);
	}
	catch(DataModelException e) {
	    context.error(this, "error in constructor: " + e.getMessage());
	}
    }
}
