/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.util.QName;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.fn.Function;

/**
 *  User Function Definition.
 * 
 */
public class FunctionCall extends Expression {

    public QName   name;
    Expression[]   args = new Expression[0];

    public FunctionCall( QName name ) {
        this.name = name;
    }

    public void  addArgument( Expression arg ) {
	args = addExpr(args, arg);
    }

    public Expression  getArgument( int rank ) {
        return rank < 0 || rank >= args.length ? null : args[rank];
    }

    public Expression child(int rank) {
	return (rank < args.length)? args[rank] : null;
    }

    public void dump( ExprDump d ) {
	d.header( this, "FunctionCall" );
        d.display("name", name);
    }

    public Expression staticCheck( StaticContext context ) {
	Expression call = this;
	// TODO : some functions (count) want to check argument types their own way
	for(int a = 0; a < args.length; a++)
	    args[a] = context.staticCheck( args[a], 0 );
	// lookup simply by name: overloaded functions hold several prototypes
	// selected by Function.staticCheck(context, arg)
	// Note: staticCheck happens after all functions declarations have been processed
	try {
	    Function fun = context.functionLookup(name);
	    if(fun == null) {
		context.getLog().error( module, location, "unknown function '%1'",
					context.prefixedName(name));
		return this;
	    }
	    return fun.staticCheck(context, args, this);
	}
        catch (XQueryException e) {
            context.getLog().error( module, location,
				    "error on function '%1': "+e.getMessage(),
				    context.prefixedName(name));
	    return this;
        }
    }

    public Value eval( Focus focus, EvalContext context ) {
        throw new RuntimeException("FunctionCall.eval("+name+") : should not happen");
    }

}
