/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */
package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.dm.*;
import net.xfra.qizxopen.xquery.*;

/**
 *  class IfExpr: 
 * 
 */
public class IfExpr extends Expression {

    public Expression  cond;
    public Expression  exprThen, exprElse;

    public IfExpr( Expression cond, Expression exprThen, Expression exprElse ) {
        this.cond = cond;
        this.exprThen = exprThen;
        this.exprElse = exprElse;
    }

    public void dump( ExprDump d ) {
	d.header( this,"IfExpr" );
        d.display("cond", cond);
        d.display("then", exprThen);
        d.display("else", exprElse);
    }

    public Expression child(int rank) {
	switch(rank) {
	    case 0: return cond;
	    case 1: return exprThen;
	    case 2: return exprElse;
	}
	return null;
    }

    public Expression staticCheck( StaticContext context ) {
	cond = context.staticCheck( cond, 0 );
	exprThen = context.staticCheck( exprThen, 0 );
	exprElse = context.staticCheck( exprElse, 0 );
	type = exprThen.getType().unionWith( exprElse.getType() );
	return this;
    }

    public Value eval( Focus focus, EvalContext context ) throws XQueryException {
	context.at(this);
	if( cond.evalEffectiveBooleanValue( focus, context ) ) {
	    return exprThen.eval( focus, context );
	}
	else {
	    
	    return exprElse.eval( focus, context );
	}
    }

    public long evalAsInteger( Focus focus, EvalContext context ) throws XQueryException {
	context.at(this);
	if( cond.evalEffectiveBooleanValue( focus, context ) ) {
	    return exprThen.evalAsInteger( focus, context );
	}
	else {
	    return exprElse.evalAsInteger( focus, context );
	}
    }

    public long evalAsOptInteger( Focus focus, EvalContext context )
	throws XQueryException {
	context.at(this);
	if( cond.evalEffectiveBooleanValue( focus, context ) ) {
	    return exprThen.evalAsOptInteger( focus, context );
	}
	else {
	    return exprElse.evalAsOptInteger( focus, context );
	}
    }

    public double evalAsDouble( Focus focus, EvalContext context ) throws XQueryException {
	context.at(this);
	if( cond.evalEffectiveBooleanValue( focus, context ) ) {
	    return exprThen.evalAsDouble( focus, context );
	}
	else {
	    return exprElse.evalAsDouble( focus, context );
	}
    }

    public double evalAsOptDouble(Focus focus, EvalContext context)
	throws XQueryException {
	context.at(this);
	if( cond.evalEffectiveBooleanValue( focus, context ) ) {
	    return exprThen.evalAsOptDouble( focus, context );
	}
	else {
	    return exprElse.evalAsOptDouble( focus, context );
	}
    }

    public String evalAsString( Focus focus, EvalContext context ) throws XQueryException {
	context.at(this);
	if( cond.evalEffectiveBooleanValue( focus, context ) ) {
	    return exprThen.evalAsString( focus, context );
	}
	else {
	    return exprElse.evalAsString( focus, context );
	}
    }

    public Item evalAsItem( Focus focus, EvalContext context ) throws XQueryException {
	context.at(this);
	if( cond.evalEffectiveBooleanValue( focus, context ) ) {
	    return exprThen.evalAsItem( focus, context );
	}
	else {
	    return exprElse.evalAsItem( focus, context );
	}
    }

    public void evalAsEvents( XMLEventReceiver output, Focus focus, EvalContext context )
	throws XQueryException, DataModelException  {
	context.at(this);
	if( cond.evalEffectiveBooleanValue( focus, context ) )
	    exprThen.evalAsEvents( output, focus, context );
	else
	    exprElse.evalAsEvents( output, focus, context );
    }
}
