/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dm.*;
import java.util.Vector;

/**
 *  class LetClause: 
 * 
 */
public class LetClause extends VarClause {

    public LetClause( QName variable ) {
        super( variable );
    }

    public void dump( ExprDump d ) {
	d.header( this, "Let" );
        d.display("variable", "$"+ variable+" : "+ varType+
		  (d.pretty()? "" : " addr "+varDecl.address) );
        d.displayp(":=", expr);
    }

    public Value eval( Focus focus, EvalContext context ) throws XQueryException {
	return new Sequence( focus, context );
    }

    public class Sequence extends VarClause.Sequence
    {
	Sequence( Focus focus, EvalContext context ) {
	    super(focus, context);
	}

	public boolean next() throws XQueryException {
	    if(!source.next())
		return false;
	    try {
		context.storeLocal( varDecl.address, expr, /*declared*/type,
				    focus, context );
	    } catch(TypeException err) {
		context.error( LetClause.this,
			       "dynamic type mismatch on variable $"+ variable+
			       " : "+ err.getMessage() + ", expecting "+ varType);
	    }
	    return true;
	}

	public boolean nextCollection() throws XQueryException {
	    if(!source.nextCollection())
		return false;
	    try {
		context.storeLocal( varDecl.address, expr, /*declared*/type,
				    focus, context );
	    } catch(TypeException err) {
		context.error(LetClause.this,
			      "dynamic type mismatch on 'let' variable: "
			      + err.getMessage() + ", expecting "+ varType);
	    }
	    return true;
	}

	public Value  bornAgain() {
	    Sequence s = new Sequence( focus, context );
	    s.setSource(source.bornAgain());
	    return s;
	}
    }
}
