/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.fn.Function;
import net.xfra.qizxopen.xquery.dt.SingleDecimal;
import net.xfra.qizxopen.xquery.fn.Prototype;

/**
 *	Implementation of unary operator '-'.
 */
public class NegateOp extends Expression
{
    public Expression[] operands;

    public NegateOp( Expression expr ) {
        operands = new Expression[] { expr };
    }

    public Expression child(int rank) {
	return (rank < operands.length)? operands[rank] : null;
    }

    public void dump( ExprDump d ) {
	d.header( this, "Negate" );
        d.display("expr", operands[0]);
    }

    static Prototype[] protos = { 
        Prototype.op("-", Type.INTEGER, ExecI.class) .arg("op", Type.INTEGER),
        Prototype.op("-", Type.DECIMAL, ExecDec.class) .arg("op", Type.DECIMAL),
        Prototype.op("-", Type.FLOAT, ExecF.class) .arg("op", Type.FLOAT),
        Prototype.op("-", Type.DOUBLE, ExecD.class) .arg("op", Type.NUMERIC),
    };

    public Expression staticCheck( StaticContext context ) {
	operands[0] = context.staticCheck( operands[0], 0 );
        return context.resolve(protos, operands, this );
    }

    public static class ExecI extends Function.IntegerCall {
	public long evalAsInteger(Focus focus, EvalContext context) throws XQueryException {
	    long e1 = args[0].evalAsInteger(focus, context);
	    context.at(this);
	    return - e1;
	}
    }

    public static class ExecDec extends Function.Call {
	public Value eval( Focus focus, EvalContext context ) throws XQueryException {
	    Value e1 = args[0].eval(focus, context);
	    context.at(this);
	    return new SingleDecimal( e1.asDecimal().negate() );
	}
    }

    public static class ExecF extends Function.FloatCall {
	public float evalAsFloat(Focus focus, EvalContext context) throws XQueryException {
	    float e1 = args[0].evalAsFloat(focus, context);
	    context.at(this);
	    return - e1;
	}
    }

    public static class ExecD extends Function.DoubleCall {
	public double evalAsDouble( Focus focus, EvalContext context ) throws XQueryException {
	    double e1 = args[0].evalAsDouble(focus, context);
	    context.at(this);
	    return - e1;
	}
    }
} // end of class NegateOp

