/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dm.*;
import net.xfra.qizxopen.xquery.dt.SingleNode;

/**
 *  class NodeConstructor: 
 * 
 */
public abstract class NodeConstructor extends Expression {

    public Expression[] contents;

    public void addItem( Expression item ) {
        contents = addExpr(contents, item);
    }

    public Expression child(int rank) {
	return rank < contents.length? contents[rank] : null;
    }

    public Expression addChild(Expression child, QName name) {
	addItem(child);
	return child;
    }

    public void dump( ExprDump d ) {
	d.header( this, "NodeConstructor" );
    }

    public boolean resolvesToConstructor() {
	return true;
    }

    public Expression staticCheck( StaticContext context ) {
	for(int e = 0, E = contents.length; e < E; e++)
	    contents[e] = context.staticCheck(contents[e], 0);
	return this;
    }

    public Value eval( Focus focus, EvalContext context ) throws XQueryException {
        return new SingleNode( evalAsNode( focus, context ) );
    }
}
