/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */
package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.op.NodeSortExpr;

/**
 *	
 */
public class NodeExpression extends Expression
{
    Expression expr1, expr2;

    public NodeExpression( Expression expr1, Expression expr2 ) {
        this.expr1 = expr1;
        this.expr2 = expr2;
    }

    public Expression child(int rank) {
	return (rank == 0)? expr1 : (rank == 1)? expr2 : null;
    }

    public void dump( ExprDump d ) {
	d.header( this, getClass().getName());
        d.display("node1", expr1);
        d.display("node2", expr2);
    }

    public int getFlags() {
	return DOCUMENT_ORDER;
    }

    public Expression staticCheck( StaticContext context ) {
	expr1 = context.staticCheck( expr1, 0 );
	if( (expr1.getFlags() & DOCUMENT_ORDER) == 0)
	    expr1 = new NodeSortExpr(expr1);
	expr2 = context.staticCheck( expr2, 0 );
	if( (expr2.getFlags() & DOCUMENT_ORDER) == 0)
	    expr2 = new NodeSortExpr(expr2);
        type = Type.NODE.star;
	return this;
    }

} // end of class NodeExpression

