/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dm.*;
import java.util.Vector;

/**
 *  class OrExpr: 
 * 
 */
public class OrExpr extends BooleanExpression {

    public Expression[]  args;

    public OrExpr( Expression first ) {
        args = new Expression[] { first };
    }

    public void addExpr( Expression e ) {
	args = addExpr(args, e);
    }

    public Expression child(int rank) {
	return rank < args.length ? args[rank] : null;
    }

    public void dump( ExprDump d ) {
	d.header( this, "Or" );
	for(int i = 0; i < args.length; i++)
	    d.display("op"+i, args[i]);
    }

    public Expression staticCheck( StaticContext context ) {
	for(int i = 0; i < args.length; i++) {
	    args[i] = context.staticCheck(args[i], 0);
	}
        type = Type.BOOLEAN;
	return this;
    }

    public boolean evalAsBoolean(Focus focus, EvalContext context) throws XQueryException {
	for(int i = 0; i < args.length; i++)
	    if(args[i].evalEffectiveBooleanValue(focus, context))
		return true;
	return false;
    }
}
