/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.dm.XMLEventReceiver;
import net.xfra.qizxopen.dm.DataModelException;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dm.*;
import net.xfra.qizxopen.xquery.dt.QNameValue;

/**
 *	Computed or direct PI constructor.
 */
public class PIConstructor extends NamedConstructor
{
    public PIConstructor( String value ) {
	super(null);
	int ws = 0, L = value.length();
	for( ; ws < L; ws++)
	    if(Character.isWhitespace(value.charAt(ws)))
		break;
	this.name = new StringLiteral(value.substring(0, ws));
	this.contents =
	    new Expression[] { new StringLiteral( ws >= L ? "" : value.substring(ws+1) ) };
	type = Type.PI;	    
    }

    public PIConstructor( Expression target, Expression contents ) {
	super(target);
	if(contents != null)
	    addItem(contents);
    }

    public Node evalAsNode( Focus focus, EvalContext context ) throws XQueryException {
        QName qname = evalName(null, focus, context);
	if(qname.getNamespace() != Namespace.NONE)
	    context.error(this, "URI part of target is not empty in PI constructor");
	Node node = CoreDataModel.newPINode(qname.getLocalName());
	evalContents( node, focus, context );
	return node;
    }

    public void evalAsEvents( XMLEventReceiver output, Focus focus, EvalContext context )
	throws XQueryException, DataModelException  {
	context.at(this);

        QName target = evalName(null, focus, context);
	if(target.getNamespace() != Namespace.NONE)
	    context.error(this, "URI part of target is not empty in PI constructor");

	output.pi( target.getLocalName(), evalContents(focus, context) );
    }

} // end of class PIConstructor

