/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dm.*;

/**
 *  class PathExpr: composes several steps.
 * 
 */
public class PathExpr extends Expression
{
    public Expression[] steps = new Expression[0];
    boolean needsSort = false;
    boolean rootless = false;
    short indexBonus;	// a priori estimation of benefit of using indexes

    public PathExpr( ) {
    }

    public PathExpr( Expression firstStep ) {
	steps = new Expression[] { firstStep };
    }

    public void  addStep( Expression step ) {
	// step is union: optimise the most frequent case: /(a|b)/
	// replaced by a child:: with composite node test
	if(step instanceof UnionOp)
	    step = ((UnionOp) step).reduce();
	BasicStep prev;
	// replace //child::TEST by descendant::TEST
	if(step instanceof ChildStep && steps.length > 0 &&
	   steps[steps.length - 1] instanceof DescendantOrSelfStep && 
	   (prev = (BasicStep) steps[steps.length - 1]).nodeTest == null) {
	    // 
	    steps[steps.length - 1] = new DescendantStep(((BasicStep) step).nodeTest);
	    // prev.nodeTest = ((BasicStep) step).nodeTest;
	    return;
	}
	steps = addExpr(steps, step);
    }

    public Expression  getStep( int rank ) {
        return rank < 0 || rank >= steps.length ? null : steps[rank];
    }

    public Expression child(int rank) {
	return rank < steps.length ? steps[rank] : null;
    }

    public void dump( ExprDump d ) {
	d.header( this, "Path" );
        if(needsSort) d.display("needsSort", ""+needsSort);
        d.display("steps", steps);
    }

    public int getFlags() {
	return DOCUMENT_ORDER;	// that's our goal
    }

    public Expression staticCheck( StaticContext context ) {
	type = context.getDotType() == null ? (Type) Type.NODE.star : context.getDotType();
	//TODO single node at root for $d in ... return $d//xx
	boolean previousSameDepth = true;
	for(int e = 0, E = steps.length; e < E; e++) {
	    context.pushDotType(type);
	    Expression step = steps[e] = context.staticCheck( steps[e], 0 );
	    if(e == 0 && (step instanceof BasicStep) && !(step instanceof RootStep))
		rootless = true;
	    context.popDotType();
	    // the only case where the composition of 2 steps does not need
	    // a sort or a merge is when the first depth stays at same depth and
	    // the second step stays within the subtree of its origin.
	    int stepFlags = steps[e].getFlags();
	    
	    if( (stepFlags & DOCUMENT_ORDER) == 0 ||
		e > 0 && !( (stepFlags & WITHIN_SUBTREE) != 0 && previousSameDepth
		            || (stepFlags & WITHIN_NODE) != 0) )
		needsSort = true;
	    previousSameDepth = (stepFlags & SAME_DEPTH) != 0;
	    type = steps[e].getType();
	    // Extension: use $obj/memberX as equivalent to getMemberX(obj)
// 	    if(type instanceof WrappedObjectType) {
// 	    } else
	    // else static type of the step required to be derived from node:
	    if(!Type.NODE.star.accepts(type))
		context.error( step, "path step should have node type, not '%1', ",
			       step.getType().toString(context), null);
	}
	// TODO: check the context to see if it can stay unordered
	return needsSort? (new NodeSortExpr(this)).atSamePlaceAs(this) : (Expression)this;
	//return this;
    }

    public Value eval( Focus focus, EvalContext context ) throws XQueryException {
	Value src = getStep(0).eval( focus, context );
	return evalNextSteps(src, 1, context);
    }

    // eval remaining steps from a source
    public Value evalNextSteps(Value src, int startStep, EvalContext context )
	throws XQueryException {
	for(int s = startStep, L = steps.length; s < L; s++)
	    src = new Composition( src, getStep(s), context ); 	
	return src;
    }

    /**
     *	Composes a source with a step: from each node of the source, generate new nodes
     *  This is for dumb querying, not for collections.
     */
    public class Composition extends NodeSequenceBase implements Focus
    {
	Value source;
	Expression step;
	EvalContext context;
	Value stepSeq;
	int   position = 0, last = -1;
	Node current;

	public Composition( Value source, Expression step, EvalContext context ) {
	    this.source = source;
	    this.step = step;
	    this.context = context;
	    this.stepSeq = Value.empty;
	    position = 0;
	}

	public Value  bornAgain() {
	    return new Composition( source.bornAgain(), step, context );
	}

	public boolean next() throws XQueryException {
	    for ( ; ; ) {
		if(stepSeq.next())
		    return true;
		if( !source.next() )
		    return false;
		++ position;
		try {
		    current = source.asNode();
		}
		catch (TypeException e) {
		    context.error(step, "invalid type of path step: "+ source.getType());
		}
		// change the focus:
		context.at(step);
		stepSeq = step.eval( this, context );
	    }
	}

	public Node asNode() throws TypeException {
	    return stepSeq.asNode();
	}

	public ItemType  getType() {
	    return stepSeq.getType();
	}

	public Item asItem() throws TypeException {
	    return stepSeq.asItem();
	}

	// implementation of Focus 

	public Item  getItem() {
	    return current;
	}

	// should never work, just for completion
	public long getItemAsInteger() throws XQueryException {
	    return source.asInteger();
	}

	public int  getPosition() {
	    return position;
	}

	public int  getLast() {
	    if(last < 0) {
		try {
		    Value sba = source.bornAgain();
		    for(last = 0; sba.next(); )
			++ last;
		}
		catch (Exception e) { }	// if it happens here, it will happen later
	    }
	    return last;
	}	
    }
}
