/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.dm.NodeTest;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dm.*;
import net.xfra.qizxopen.xquery.dt.ReverseArraySequence;

/**
 *  class PrecedingSiblingStep: 
 * 
 */
public class PrecedingSiblingStep extends ReverseStep {

    public PrecedingSiblingStep( NodeTest nodeTest ) {
        super( nodeTest );
    }

    public int getFlags() {
	return super.getFlags() + SAME_DEPTH;
    }

    public void dump( ExprDump d ) {
	d.header( this, "PrecedingSiblingStep" );
        d.display("nodeTest", nodeTest == null ? null : nodeTest.toString());
	d.display("naturalStepOrder", ""+naturalStepOrder);
    }

    public Value eval( Focus focus, EvalContext context ) throws XQueryException {
	checkFocus(focus, context);
	Value s = focus.getItem().asNode().getPrecedingSiblings( nodeTest );
	// TODO utterly inefficient to use preceding[1] ...
	return naturalStepOrder ? new ReverseArraySequence( s) : s;
    }
}
