/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.dm.NodeTest;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dm.*;
import net.xfra.qizxopen.xquery.dt.SingleNode;

/**
 * 
 */
public class RootStep extends BasicStep {

    public RootStep( NodeTest nodeTest ) {
        super( nodeTest );
    }

    public void dump( ExprDump d ) {
	d.header( this, "RootStep" );
        d.display("nodeTest", nodeTest == null ? null : nodeTest.toString());
    }

    public int getFlags() {
	return DOCUMENT_ORDER + WITHIN_SUBTREE + SAME_DEPTH;
    }

    public Value eval( Focus focus, EvalContext context ) throws XQueryException {
	context.at(this);
	checkFocus(focus, context);
	return new SingleNode(focus.getItem().asNode().getDocument());
    }
}
