/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.util.*;
import java.util.Vector;

/**
 *  class SchemaContext: 
 * 
 */
public class SchemaContext extends LeafExpression {

    public boolean startsFromType = false;
    public boolean endsWithSlash = false;
    public Vector steps = new Vector();

    public SchemaContext( boolean startsFromType ) {
        this.startsFromType = startsFromType;
    }

    public void  addStep( QName step ) {
        steps.add(step);
    }

    public QName  getStep( int rank ) {
        return rank < 0 || rank >= steps.size() ? null : (QName) steps.get(rank);
    }
    
    public boolean isSimpleName() {
	return !startsFromType && steps.size() == 1;
    }

    public void dump( ExprDump d ) {
	d.println( "SchemaContext" );
        d.display("startsFromType", ""+startsFromType);
        d.display("steps", steps);
    }

    public Value eval( Focus focus, EvalContext context ) throws XQueryException {
        throw new RuntimeException("SchemaContext not implemented");
    }
}
