/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.dm.*;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dm.*;
import net.xfra.qizxopen.xquery.dt.SingleItem;
import net.xfra.qizxopen.xquery.dt.SingleNode;

/**
 *  class SelfStep: 
 * 
 */
public class SelfStep extends BasicStep {

    public SelfStep( NodeTest nodeTest ) {
        super( nodeTest );
    }

    public void dump( ExprDump d ) {
	d.header( this, "SelfStep" );
        d.display("nodeTest", nodeTest == null ? null : nodeTest.toString());
    }

    public int getFlags() {
	return DOCUMENT_ORDER + WITHIN_SUBTREE + SAME_DEPTH;
    }

    public Expression staticCheck( StaticContext context ) { 
	super.staticCheck(context);
	if(nodeTest == null) {
	    if(context.getDotType() == null)
		context.error(this, "'.' is undefined in this context", null, null);
	    else
		type = context.getDotType();
	}
	return this;
    }

    public Value eval( Focus focus, EvalContext context ) throws XQueryException {
	checkFocus(focus, context);
	if(nodeTest == null)	// pure dot alias current-item()
	    return new SingleItem(focus.getItem()); // inefficient TODO but complex	
	// it is a real path step and generates a Node:
	net.xfra.qizxopen.xquery.dm.Node self = focus.getItem().asNode();
	if( nodeTest.needsNode() ? nodeTest.accepts(self)
	    : nodeTest.accepts(self.getNature(), self.getNodeName()))
	    return new SingleNode(self);
	return Value.empty;
    }

    public long evalAsInteger( Focus focus, EvalContext context ) throws XQueryException {
	checkFocus(focus, context);
	return focus.getItemAsInteger();
    }

/***
    public String evalAsString( Focus focus, EvalContext context ) throws XQueryException {
	checkFocus(focus, context);
	return focus.asString();
    }
**/
}
