/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.dm.*;

/**
 *	Text literal inside Element constructor.
 */
public class TextLiteral extends StringLiteral
{
    public TextLiteral( String value ) {
        super(value);
    }

    public void dump( ExprDump d ) {
	d.header( this, "TextLiteral" );
        d.display("value", value);
    }

    public void evalAsEvents( XMLEventReceiver output, Focus focus, EvalContext context )
	throws XQueryException, DataModelException {
	context.at(this);
	output.text( value );
    }

} // end of class TextLiteral

