/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */
package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dm.*;
import net.xfra.qizxopen.xquery.dt.SingleString;

/**
 *	Extension: try { expr } catch($err) { expr }
 */
public class TryCatchExpr extends Expression
{
    Expression caught;
    Expression handler;
    QName errVar;
    LocalVariable varDecl;

    public TryCatchExpr(Expression caught, QName errVar, Expression handler) {
	this.caught = caught;
	this.handler = handler;
	this.errVar = errVar;	
    }

    public Expression child(int rank) {
	return rank == 0 ? caught : rank == 1 ? handler : null;
    }

    public void dump( ExprDump d ) {
	d.header( this, "TryCatch" );
        d.display("caught", caught);
        d.display("handler", handler);
    }

    public Expression staticCheck( StaticContext context ) {
	caught = context.staticCheck( caught, 0 );
	type = caught.getType();

	LocalVariable mark = context.markLocalVariables();
	varDecl = context.defineLocalVariable(errVar, Type.STRING, this);
	handler = context.staticCheck( handler, 0 );
	context.popLocalVariables(mark);

	type = type.unionWith( handler.getType() );
	return this;
    }

    public Value eval(Focus focus, EvalContext context) throws XQueryException {
	context.at(this);
	try {
	    return caught.eval( focus, context );
	}
	catch (EvalException e) {
	    //Log log = context.getStaticContext().getLog();
	    //log.trace( module, location, "caught "+ e.getMessage(), null);
	    context.storeLocal(varDecl.address,
			       new SingleString(e.getMessage()),
			       false/*current*/);
	    return handler.eval( focus, context );
	}
    }
}
