// Ankou Splash
// Copyright (C) 2004 Teru KAMOGASHIRA

package jp.go.kokken.Ankou;

import java.awt.*;
import java.util.*;
import javax.swing.*;

/**
 * A simple splash screen
 */
public class AnkouSplash
    extends JWindow
{
    AnkouSplash(Frame owner)
    {
	super(owner);
	
	Container container = getContentPane();
	JPanel panel = new JPanel(new BorderLayout());
	JLabel logo =
	    new JLabel(new ImageIcon(AnkouSplash.class.getClassLoader().getResource("jp/go/kokken/Ankou/Ankou.jpg")));
	
	JLabel text = new JLabel("Ankou " + TaminoClient.VERSION, JLabel.CENTER);
	Font textFont = null;
	String[] preferredFontNames = new String[] { "Arial", "Helvetica", "SansSerif" };
	
	Set availableFontNames = new HashSet();
	Font[] allFonts =
	    GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
	
	for (int i = 0; i < allFonts.length; i++)
	    {
		availableFontNames.add(allFonts[i].getName());
	    }
	
	for (int i = 0; i < preferredFontNames.length; i++)
	    {
		if (availableFontNames.contains(preferredFontNames[i])) 
		    {
			textFont =
			    new Font(preferredFontNames[i], Font.PLAIN, 12);
			
			System.out.println("Using font=" + textFont.getName());
			
			break;
		    }
	    }
	
	if (textFont == null)
	    {
		System.out.println("Using basic font");
		textFont = text.getFont();
	    }
	
	text.setFont(textFont.deriveFont(16f).deriveFont(Font.BOLD));
	text.setBackground(Color.white);
	text.setForeground(Color.black);
	text.setBorder(BorderFactory.createLoweredBevelBorder());
	panel.add(logo, BorderLayout.CENTER);
	panel.add(text, BorderLayout.SOUTH);
	panel.setBorder(BorderFactory.createLineBorder(Color.black, 1));
	
	container.add(panel);
	pack();
    }
    
    public static void centerOnScreen(Component component)
    {
	Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
	component.setLocation((screenSize.width / 2) - (component.getWidth() / 2),
			      (screenSize.height / 2) - (component.getHeight() / 2));
    }
}
