// Tamino XQuery Driver
// Copyright (C) 2004 Teru KAMOGASHIRA

package jp.go.kokken.Ankou;

import org.apache.log4j.Logger;

import com.softwareag.tamino.db.api.accessor.*;
import com.softwareag.tamino.db.api.common.*;
import com.softwareag.tamino.db.api.connection.*;
import com.softwareag.tamino.db.api.objectModel.*;
import com.softwareag.tamino.db.api.objectModel.dom.*;
import com.softwareag.tamino.db.api.objectModel.dom4j.*;
import com.softwareag.tamino.db.api.response.*;

import java.io.*;
import java.util.regex.*;

/**
 * Tamino Connection interface.
 * 
 *  usage note:
 *  1. regieterDB("http://localhost/tamino/mydb")
 *  2. regieterCollectionName("IPUCollection")
 *  2. submitQuery("for $s in input()//LUW where 
 *                 $s/@LUWLemma='??' return $s/@LUWLemma")
 *  3. check the return code of 2.
 *  4. if there are some responses. get them:
 *     TXMLObjectIterator iterator = getResponseInterator()
 *     while(iterator.hasNext())
 *       TXMLObject xml = iterator.next();
 *       process xml
 *  5. close()
 *    
 */
public class Client
    extends QueryDriver
{
    TConnection connection = null;
    TResponse response = null;
    String dbURI = null;
    String collectionName;
    
    /**
     * QUERY饤֥ޤ
     */
    public Client()
    {
    	super();
	logger = Logger.getLogger(Client.class);
	return ;
    }
    
    /**
     * Connect to the DB dbURI and returns TConnection session.
     *
     * @return returns TConnection<br>
     * @exception TConnectionException failed to connect.<br>
     */
    private TConnection connectDB(String dbURI)
	throws TConnectionException
    {
	logger.debug("connectDB - entering " + dbURI);
	TConnectionFactory connectionFactory = TConnectionFactory.getInstance();
	// Obtain the connection to the database
	logger.debug("connectDB - exiting");
	return connectionFactory.newConnection(dbURI);
    }
    
    /**
     * Connect to the Collection in the Database and returns accessor.
     *
     * @return returns TXMLObjectAccessor which will be used in the xquery section.<br>
     */
    private TXMLObjectAccessor connectCollectionName(TConnection connection, String collectionName)
    {
	// Instantiate the specific TDOM4JObjectModel	
	TXMLObjectModel dom4jObjectModel = TDOM4JObjectModel.getInstance();
	// Do the object model registration.
	TXMLObjectModel.register(dom4jObjectModel);
	
	// Obtain the concrete TXMLObjectAccessor with an underyling DOM4J object model
	return connection.newXMLObjectAccessor(TAccessLocation.newInstance(collectionName),
					       dom4jObjectModel);
    }
     
    /**
     * DBcollectionNameϿޤ
     * ʸϰʲΤ褦ˤʤäƤޤ
     * http://localhost/tamino/mydb?IPUCollection
     * DBuri?collectionName
     *
     * @param complex ʣʸ
     */
    public void registerDBAndCollectionName(String complex)
	throws IllegalArgumentException
    {
	Pattern pattern = Pattern.compile("\\?");
	String[] strs = pattern.split(complex);
	if (strs.length < 2)
	    throw new IllegalArgumentException();
	registerDB(strs[0]);
	registerCollectionName(strs[1]);
	return ;
    }
   
    /**
     * DBϿޤ
     * @param QueryString XQueryʸ
     */
    public void registerDB(String uri)
    {
	dbURI = uri;
    }
        
    /**
     * collectionNameϿޤ
     * @param QueryString XQueryʸ
     */
    public void registerCollectionName(String collection)
    {
	collectionName = collection;
    }
    
    /**
     * Send X-Query and return result string.
     *
     * @return returns 0 if it is ok, otherwise returns -1 ? <br>
     */
    public String submitQuery(String queryString)
	throws IOException,
	       IllegalArgumentException,
	       java.lang.OutOfMemoryError
    {
	logger.debug("submitXQuery - entering " + dbURI + " " + collectionName + " " + queryString);
	
	// check arguments
	if (dbURI == null||collectionName == null)
	    throw new IllegalArgumentException();
	// dbURI must not end with /.
	if (dbURI.substring(dbURI.length()-1, dbURI.length()).equals("/"))
	    throw new IllegalArgumentException();
	
	if (queryString != null)
	    {
		qstring = queryString;
	    }
	else
	    {
		logger.debug("submitQuery - QueryString was replaced with registered query string. (QueryString was null.)");
	    }
	
	logger.debug("submitQuery - QueryString:\n======\n" + qstring + "\n======\n");
	
	// make a connection to dbURI
	TConnection connection = null;
	try
	    {
		connection = connectDB(dbURI);
	    }
	catch (TConnectionException e)
	    {
		logger.error("submitXQuery - connection failed: " + e);
		throw new IOException(e.toString());
	    }
	
	// obtain a accessor
	TXMLObjectAccessor accessor = connectCollectionName(connection, collectionName);
	
	// Initiate a xquery
	TXQuery xquery = TXQuery.newInstance(qstring);

	try
	    {
		return (rstring = performXQuery(xquery, accessor));
	    }
	catch(TException e)
	    {
		logger.error("submitXQuery - xquery failed: " + e);
		throw new IOException(e.toString());
	    }
    }
    
    private String performXQuery(TXQuery xquery, TXMLObjectAccessor xmlAccessor)
	throws TException,
	       TXQueryException
    {
	// Now lets make a xquery on the updated object
	TResponse response = xmlAccessor.xquery( xquery );
	TXMLObjectIterator iterator = response.getXMLObjectIterator();
	String result = new String("");
	while (iterator.hasNext())
	    {
		TXMLObject xmlObject = iterator.next();
		// Write the XML content to a StringWriter
		StringWriter stringWriter = new StringWriter();
		xmlObject.writeTo( stringWriter );
		result = result + stringWriter.toString();
	    }
	return result;
    }

    public String getVersion()
    {
	String version = "Sheffield 2.3.0.0 " + "Newcastle 3.1.0.0 " + "York 3.1.0.504 " + "Washington 4.1.0.0";
	return version;
    }
}
