// Copyright (C) 2004 Teru KAMOGASHIRA

package jp.go.kokken.Ankou;

import org.apache.log4j.Logger;

import javax.swing.*;
import java.awt.event.*;
import java.awt.*;
import javax.swing.table.*;

import javax.xml.parsers.*;
import org.apache.xerces.parsers.*;
import org.xml.sax.*;
import org.xml.sax.helpers.*;
import java.io.*;
import java.util.Vector;

/**
 * XMLη̤JTable˹碌ޤ
 *
 * <p>ǧϷϺΤȤΤȤǤ</p>
 * <pre>
 * &lt;result&gt;
 * &lt;item&gt;
 * &lt;IPU hidden="yes" IPUStartTime="00030.088"/&gt;
 * &lt;IPU IPUEndTime="00060.088"/&gt;
 * &lt;/item&gt;
 * &lt;/result&gt;
 * </pre>
 *
 * <p>줾&lt;item&gt;Tableˤʤꡢ
 * &lt;IPULUWʤ&gt;ϥȤʤޤԤο
 * ϤitemλTAGοǷޤǤϣǤ</p>
 *
 * <p>attributeǡhidden°ĤƤ礽ιԤɽޤ
 * getHiddenAttribute()ǼǤޤʤɤ
 * Ȥ礳°Ȥ뤿Ǥ
 * ʰǤʤΤhidden°¸ߤ
 * ɽѥǡȤʤޤ</p>
 *
 * <p><code>getAttribute</code>ޤ<code>getHiddenAttribute</code>
 * ͤˤϡǤ&quot;IPU/@IPUStartTime&quot;Ǹ
 * Ʋ</p>
 *
 * <p>JTableTableModelȱ°դΥǡTableModel
 * ̤¸Ƥޤ</p>
 */
public class CompileResults
    extends DefaultHandler
{
    /**
     * log4j logger
     */
    static Logger logger =
	Logger.getLogger(CompileResults.class);
    
    /**
     * Τޤ޻ȤSWING component
     */
    public JTable table = null;
    
    class ReadOnlyTableModel extends DefaultTableModel
    {
	public boolean isCellEditable(int rowIndex,int colmunIndex)
	{
	    return false;
	}
    }
    
    /**
     * ơ֥
     */
    ReadOnlyTableModel model = null;
    
    /**
     * °ĤΥǡΥơ֥
     */
    ReadOnlyTableModel hiddenmodel = null;
    
    /**
     * ơ֥ޤ
     */
    public CompileResults()
    {
	logger.debug("CompileResults - entering");
	
	// Υơ֥ǽ
	model = new ReadOnlyTableModel();
	hiddenmodel = new ReadOnlyTableModel();
	table = new JTable(model);
	
	record = new Vector();
	headrecord = new Vector();
	
	hiddenrecord = new Vector();
	hiddenheadrecord = new Vector();
	
	logger.debug("CompileResults - exiting");
	return ;
    }
    
    /**
     * JTableơ֥ΰ־ιԤɽꤷޤ
     * ΥƱꤵޤ
     * @param columnNames ɽʸVector
     * @exception Exception 顼
     */
    public void setHeadColumn(Vector columnNames)
	throws SAXException
    {
	logger.debug("setHeadColumn - entering " + columnNames);
	
	if (columnNames == null)
	    {
		throw new SAXException(new Exception());
	    }
	// ơ֥
	// 
	model.setColumnCount(0);
	//  Τ
	model.setRowCount(0);
	for (int i = 0;i < columnNames.size();i ++)
	    {
		model.addColumn((String)columnNames.get(i));
	    }
	
	logger.debug("setHeadColumn - exiting");
	return ;
    }
    
    /**
     * °ǡTableơ֥ΰ־ιԤɽꤷޤ
     * ΥƱꤵޤ
     * @param columnNames ɽʸVector
     * @exception Exception 顼
     */
    public void setHiddenHeadColumn(Vector columnNames)
	throws SAXException
    {
	logger.debug("setHeadColumn - entering " + columnNames);
	
	if (columnNames == null)
	    {
		throw new SAXException(new Exception());
	    }
	// ơ֥
	// 
	hiddenmodel.setColumnCount(0);
	//  Τ
	hiddenmodel.setRowCount(0);
	for (int i = 0;i < columnNames.size();i ++)
	    {
		hiddenmodel.addColumn((String)columnNames.get(i));
	    }
	
	logger.debug("setHeadColumn - exiting");
	return ;
    }
    
    /**
     * JTable˥쥳ɹԤɲäޤ
     * ơ֥­ʤ褦ȡƣ­ޤ
     * ʶ顼Τ
     * @param Names ɽʸVector
     * @exception SAXException 顼
     */
    public void addRow(Vector Names)
	throws SAXException
    {
	logger.debug("addRow - entering " + Names);
	
	if (Names == null)
	    {
		throw new SAXException(new Exception());
	    }
	
	// ưŪ򹭤ޤ
	// avoid errors of reading >> length
	if (Names.size() > model.getColumnCount())
	    {
		// 줬ƤӽФ줿Ƥ뤫å
		// Nullʤߡ̾ɲ
		if (headrecord.size() != Names.size())
		    {
			// ơ֥
			// 
			model.setColumnCount(0);
			//  Τ
			model.setRowCount(0);
			
			for (int i = 0;i < Names.size();i ++)
			    {
				model.addColumn("ǡ");
			    }
		    }
		// ̵äݤäɲ
		else
		    {
			setHeadColumn(headrecord);
		    }
	    }
	
	// Why Vector.clone() ?
	// JavaǤϡȤä֥ȤϼΤƤΤ
	// ԡϤʤȡǻȤ褦ȤNullPointer
	// Τ褦ʤȤˤʤ뤫顣ǤʤѤǤ͡
	// ޤ줬JavaäݤȤʡȤפäꤹΤǤ
	// ݥ󥿤ΤȤɹͤʤʤ
	// ޤ񤱤ʤ
	model.addRow((Vector)Names.clone());
	
	logger.debug("addRow - exiting");
	return ;
    }
    
    /**
     * ǡTable˥쥳ɹԤɲäޤ
     * ơ֥­ʤ褦ȡƣ­ޤ
     * ʶ顼Τ
     * @param Names ɽʸVector
     * @exception SAXException 顼
     */
    public void addHiddenRow(Vector Names)
	throws SAXException
    {
	logger.debug("addRow - entering " + Names);
	
	if (Names == null)
	    {
		throw new SAXException(new Exception());
	    }
	
	// ưŪ򹭤ޤ
	// avoid errors of reading >> length
	if (Names.size() > hiddenmodel.getColumnCount())
	    {
		// 줬ƤӽФ줿Ƥ뤫å
		// Nullʤߡ̾ɲ
		if (headrecord.size() != Names.size())
		    {
			// ơ֥
			// 
			hiddenmodel.setColumnCount(0);
			//  Τ
			hiddenmodel.setRowCount(0);
			
			for (int i = 0;i < Names.size();i ++)
			    {
				hiddenmodel.addColumn("ǡ");
			    }
		    }
		// ̵äݤäɲ
		else
		    {
			setHeadColumn(headrecord);
		    }
	    }
	
	// Why Vector.clone() ?
	// JavaǤϡȤä֥ȤϼΤƤΤ
	// ԡϤʤȡǻȤ褦ȤNullPointer
	// Τ褦ʤȤˤʤ뤫顣ǤʤѤǤ͡
	// ޤ줬JavaäݤȤʡȤפäꤹΤǤ
	// ݥ󥿤ΤȤɹͤʤʤ
	// ޤ񤱤ʤ
	hiddenmodel.addRow((Vector)Names.clone());
	
	logger.debug("addRow - exiting");
	return ;
    }
    
    /**
     * ̤ʸ󤫤ơ֥ޤö
     * ơ֥Ƥ鿷˺ʤޤ
     *
     * @param results ̤ʸ
     * @exception IllegalArgumentException ̤λ
     * @exception SAXException XMLѡ顼
     * @exception IOException IO顼̤ϵʤϤ
     */
    public void registerResults(String results)
	throws IllegalArgumentException,
	       SAXException,
	       IOException
    {
	logger.debug("registerResults - entering " + results);
	
	if (results == null)
	    {
		throw new IllegalArgumentException();
	    }
	
	logger.debug("registerResults - creating XMLReader");
	XMLReader parser =
	    XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
	
	parser.setContentHandler(this);
	parser.setDTDHandler(this);
	parser.setErrorHandler(this);
	logger.debug("registerResults - starting parse");
	parser.parse(new InputSource(new java.io.StringReader(results)));
	
	logger.debug("registerResults - exiting");
	return ;
    }
    
    /**
     * ɽʤ°õƤ֤ͤޤ
     * @param AttributeName õ°̾
     * @param column ܤ֤ͤ
     * @return Ĥ͡Ĥʤnull֤ޤ
     */
    public String getHiddenAttribute(String AttributeName, int column)
    {
	logger.debug("getHiddenAttribute - entering ");
	
	if (AttributeName == null)
	    {
		return null;
	    }
	
	for(int i = 0;i < hiddenmodel.getColumnCount();i ++)
	    {
		logger.debug("getHiddenAttribute - " + i 
			     + " " + hiddenmodel.getColumnName(i));
		if(hiddenmodel.getColumnName(i).equals(AttributeName))
		    {	
			logger.debug("getHiddenAttribute - found " + i);
			
			try
			    {
				String value =
				    (String)hiddenmodel.getValueAt(column, i);
				return value;
			    }
			catch(ArrayIndexOutOfBoundsException e)
			    {
				return null;
			    }
		    }
	    }
	return null;
    }
    
    /**
     * °õƤ֤ͤޤ
     * @param AttributeName õ°̾
     * @param column ܤ֤ͤ
     * @return Ĥ͡Ĥʤnull֤ޤ
     */
    public String getAttribute(String AttributeName, int column)
    {
	if (AttributeName == null)
	    {
		return null;
	    }
	
	for(int i = 0;i < model.getColumnCount();i ++)
	    {
		if(model.getColumnName(i).equals(AttributeName))
		    {
			try
			    {
				String value =
				    (String)model.getValueAt(i, column);
				return value;
			    }
			catch(ArrayIndexOutOfBoundsException e)
			    {
				return null;
			    }
		    }
	    }
	return null;
    }
    
    ////////////////////////////////////////////////////////////////////
    // ʹ DefaultHandler 
    ////////////////////////////////////////////////////////////////////
    
    /**
     * ĥ꡼ο
     */
    int depth = 0;
    
    /**
     * ɤĥ꡼ο
     */
    int previousdepth = 0;
    
    /**
     * ƥ쥳ɤäʥơ֥Τ
     */
    int count = 0;
    
    /**
     * ơ֥Ͽ뤿Υ쥳ɤVECTOR (1 item)
     */
    Vector record = null;    
    
    /**
     * ơ֥ϿľVECTOR
     */
    Vector prerecord = null;    

    /**
     * ơ֥إåVECTOR
     */
    Vector headrecord = null;    
    
    // ʲ°ΤĤǡ
    
    /**
     * ơ֥Ͽ뤿Υ쥳ɤVECTOR (1 item)
     */
    Vector hiddenrecord = null;    
    
    /**
     * ơ֥إåVECTOR
     */
    Vector hiddenheadrecord = null;    

    /**
     * Receive notification of the beginning of the document.
     *
     * @exception org.xml.sax.SAXException Any SAX exception, possibly
     *            wrapping another exception.
     */
    public void startDocument()
	throws SAXException
    {
	logger.debug("startDocument - entering");

	depth = 0;
	previousdepth = 0;
	count = 0;
	
	record.clear();
	headrecord.clear();
	
	hiddenrecord.clear();
	hiddenheadrecord.clear();

	logger.debug("startDocument - exiting");
	return ;
    }
    
    /**
     * Receive notification of the end of the document.
     *
     * @exception org.xml.sax.SAXException Any SAX exception, possibly
     *            wrapping another exception.
     */
    public void endDocument()
	throws SAXException
    {
	logger.debug("endDocument - entering");

	depth = 0;
	record.clear();
	prerecord.clear();
	headrecord.clear();

	hiddenrecord.clear();
	hiddenheadrecord.clear();

	logger.debug("endDocument - exiting");
	return ;
    }
    
    /**
     * Receive notification of the beginning of an element.
     *
     * <p>item쥳ɤɤ߹ǥơ֥
     * ᥤδؿǤ1ܤitem쥳ɤɤ
     * setHeadColumn(String[] columnNames)Ѥ
     * ơ֥νԤʤޤʹߡ
     * 쥳ɤ礭ϸ§ȤڤΤƤޤ</p>
     *
     * @param uri The Namespace URI, or the empty string if the
     *        element has no Namespace URI or if Namespace
     *        processing is not being performed.
     * @param localName The local name (without prefix), or the
     *        empty string if Namespace processing is not being
     *        performed.
     * @param qName The qualified name (with prefix), or the
     *        empty string if qualified names are not available.
     * @param atts The attributes attached to the element.  If
     *        there are no attributes, it shall be an empty
     *        Attributes object.
     * @exception org.xml.sax.SAXException Any SAX exception, possibly
     *            wrapping another exception.
     */
    public void startElement(java.lang.String uri,
			     java.lang.String localName,
			     java.lang.String qName,
			     Attributes atts)
	throws SAXException
    {
	logger.debug("startElement - entering depth:" + depth + " " + qName + " Attributes:" + atts.getLength());

	// ؤοưޤޤ
	// 0 롼(=result)
	// nop
	// 1 item
	// VECTORν
	// 2 쥳
	// VECTORɲ
	
	switch (depth)
	    {
	    case 0:
		previousdepth = 0;
		break;
	    case 1:
		previousdepth = depth;
		
		headrecord.clear();
		record.clear();
		
		hiddenheadrecord.clear();
		hiddenrecord.clear();
		break;
	    case 2:
		previousdepth = depth;
		// ° hidden ɤ ʤäȰ°ס
		// ⤷°Ĥʤä
		// ɽ°ȤϿ
		if (atts.getLength() == 0)
		    {
			record.add("");
		    }
		else if (atts.getLength() == 1)
		    {
			headrecord.add(qName + "/@" + atts.getQName(0));
			record.add(atts.getValue(0));
		    }
		// ⤷°Ĥä
		else if (atts.getLength() == 2)
		    {
			if (atts.getQName(0).equals("hidden"))
			    {
				// hiddenʤ
				// ⤦ɽѤ°Ͽ
				hiddenheadrecord.add(qName + "/@" + 
					       atts.getQName(1));
				hiddenrecord.add(atts.getValue(1));
			    }
			else if (atts.getQName(1).equals("hidden"))
			    {
				// hiddenʤ
				// ⤦ɽѤ°Ͽ
				hiddenheadrecord.add(qName + "/@" + 
					       atts.getQName(0));
				hiddenrecord.add(atts.getValue(0));
			    }
			else
			    {
				;
			    }
		    }
		else
		    {
			;
		    }
		// ʾ°פʾ櫓Ǥ

		break;
	    default:
		// Τ̵
		;
	    }
	
	// ǤϤޤäΤǳؤϰľ夬ޤ
	depth ++;
	logger.debug("startElement - exiting");
	return ;
    }
    
    /**
     * Receive notification of the end of an element.
     *
     * @param uri The Namespace URI, or the empty string if the
     *        element has no Namespace URI or if Namespace
     *        processing is not being performed.
     * @param localName The local name (without prefix), or the
     *        empty string if Namespace processing is not being
     *        performed.
     * @param qName The qualified XML 1.0 name (with prefix), or the
     *        empty string if qualified names are not available.
     * @exception org.xml.sax.SAXException Any SAX exception, possibly
     *            wrapping another exception.
     */
    public void endElement(java.lang.String uri,
			   java.lang.String localName,
			   java.lang.String qName)
	throws SAXException
    {
	// ǤäΤǳؤĲޤ
	depth --;
	
	logger.debug("endElement - entering depth:" + depth + " " + qName);
	
	// ؤοưޤޤ
	// 1 롼(=result)
	// nop
	// 2 item
	// VECTORΥơ֥ؤϿ
	
	switch (depth)
	    {
	    case 0:
		previousdepth = 0;
		break;
	    case 1:
		previousdepth = depth;
		
		if (count == 0)
		    {
			// Υ쥳ϿˤΤ
			// itemʲTAGοơ֥ȿǤޤ
			// Ʊ˹Ԥʤޤ
			setHeadColumn(headrecord);
			setHiddenHeadColumn(hiddenheadrecord);
		    }
		// 쥳ɤϿƥơ֥ɲäޤ
		// ľΥ쥳ɤƱʤɲäʤ
		if (!record.equals(prerecord))
		    {
			addRow(record);
			addHiddenRow(hiddenrecord);
			prerecord = (Vector)record.clone();
		    }
		
		// Ͽ쥳ɤο夲ޤ
		count ++;
		break;
	    default:
		// Τ̵
		;
	    }

	logger.debug("endElement - exiting");
	return ;
    }
    
    /**
     * Receive notification of character data.
     *
     * @param ch The characters from the XML document.
     * @param start The start position in the array.
     * @param length The number of characters to read from the array.
     * @exception org.xml.sax.SAXException Any SAX exception, possibly
     *            wrapping another exception.
     * @see #ignorableWhitespace 
     * @see org.xml.sax.Locator
     */
    public void characters(char[] ch,
			   int start,
			   int length)
	throws SAXException 
    {
	logger.debug("characters - entering length:" + length);
	
	return ;
    }
    
    /**
     * Receive notification of a warning.
     *
     * @param e The warning information encapsulated in a
     *                  SAX parse exception.
     */
    public void warning(SAXParseException e)
    {
        System.out.println("ٹ: " + e.getLineNumber() +"");
        System.out.println(e.getMessage());
    }
    
 
    /**
     * Receive notification of a recoverable error.
     *
     * @param e The error information encapsulated in a
     *                  SAX parse exception.
     */
    public void error(SAXParseException e)
    {
        System.out.println("顼: " + e.getLineNumber() +"");
        System.out.println(e.getMessage());
    }
    
    /**
     * Receive notification of a non-recoverable error.
     *
     * @param e The error information encapsulated in a
     *                  SAX parse exception.  
     */
    public void fatalError(SAXParseException e) {
        System.out.println("ʥ顼: " + e.getLineNumber() +"");
        System.out.println(e.getMessage());
    }

}
