// File IO Interface
// Copyright (C) 2004 Teru KAMOGASHIRA

package jp.go.kokken.Ankou;

import org.apache.log4j.Logger;

import java.io.*;

import javax.swing.table.*;
import javax.swing.*;
import java.awt.*;
import java.util.*;

import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

import javax.xml.transform.*;
import javax.xml.transform.dom.*;
import javax.xml.transform.stream.*;

/**
 * 両̤ե¸ե뤫ɤ߹ꤹstaticؿ
 *
 * <p>ե¸ե뤫ɤ߹ꤹоݤ
 * ʲ̤Ǥ</p>
 * <ul>
 *   <li>о</li>
 *   <li>̤XML</li>
 *   <li>Query</li>
 * </ul>
 */
public class IOFile
{
    IOFile()
    {
    }
    
    /**
     * log4j logger
     */
    static Logger logger =
	Logger.getLogger(IOFile.class);

    /**
     * ե뤬¸ߤ뤫Τޤ¸ߤʤtrue֤ޤ
     * 
     * @param filename ѴΥե̾
     */
    static public boolean isNewFile(String filename)
    {
        File file = new File(filename);
        return (!file.exists());
    }
        
    /**
     * ɽƥ桼ե̾ޤ
     * 
     * @param component ν°
     * @param mode μ("Save"/"Open")
     * @exception IOException destnulläեˤʤꤲޤ
     */
    static private String getFilenameFromUser(Component component, String mode)
    {	
	JFileChooser choose = new JFileChooser();
	String file = null;
	int ret = 0;
	
	if (mode.equals("Save"))
	    {
		ret = choose.showSaveDialog(component);
	    }
	else if(mode.equals("Open"))
	    {
		ret = choose.showOpenDialog(component);
	    }
	else 
	    return "";
	
	if (JFileChooser.APPROVE_OPTION != ret)
	    return "";
	file = choose.getSelectedFile().getPath();
	
	logger.debug("getFilenameFromUser - got " + file);
	if (mode.equals("Save")&&(!isNewFile(file)))
	    {
		int value =
		    JOptionPane.showConfirmDialog(component,
						  "ꤷեϤǤ¸ߤޤ\n񤭤ޤ",
						  "overwrite",
						  JOptionPane.YES_NO_OPTION);
		
		if (value != JOptionPane.YES_OPTION)
		    {
			return "";
		    }
	    }
	if (mode.equals("Opem")&&isNewFile(file))
	    {
		JOptionPane.showMessageDialog(component,
					      "ʥեϤޤ" + file);
		return "";
	    }
	
	return file;
    }
    
    static public void outputFileFromString(String dest,
					    Component component)
	throws IOException,
	       IllegalArgumentException,
	       FileNotFoundException,
	       SecurityException
    {
	String fileName = getFilenameFromUser(component, "Save");
	if (fileName.equals(""))
	    throw new IllegalArgumentException();
	outputFileFromString(dest, fileName);
	return ;
    }
    
    /**
     * Ϳ줿String򤽤Τޤޥե˽񤭽Фޤ
     * 
     * @param dest 񤭽Фʸ
     * @param fileName ѴΥե̾
     * @exception IOException destnulläեˤʤꤲޤ
     */
    static public void outputFileFromString(String dest,
					    String FileName)
	throws IOException,
	       IllegalArgumentException,
	       FileNotFoundException,
	       SecurityException
    {
	// ޤǤ뤫å
	if (dest == null||FileName == null)
	    {
		throw new IllegalArgumentException();
	    }
	
	// ե򳫤񤭹
	PrintWriter out = 
	    new PrintWriter(new OutputStreamWriter(new FileOutputStream(FileName), "UTF-8"));
	
	// 
	out.print(dest);
	out.close();
	return ;
    }

    static public void outputFileFromTable(DefaultTableModel model,
					   Component component,
					   String separator)
	throws IOException,
	       IllegalArgumentException,
	       FileNotFoundException,
	       SecurityException
    {
	String fileName = getFilenameFromUser(component, "Save");
	if (fileName.equals(""))
	    throw new IllegalArgumentException();
	outputFileFromTable(model, fileName, separator);
	return ;
    }
    
    /**
     * Ϳ줿DefaultTableModelCSVեޤ
     * Ǵ֤Separator(,tabʤ)Ǥޤ
     * եEncodingutf-8(Javaɸ)줷Ƥޤ
     * ԥɤLFǤ
     * tableι/ɤ餫0λ㳰ޤ
     * 
     * @param model ѴDefaultTableModel
     * @param FileName ѴΥե̾
     * @param Separator Ǵ֤ʸnull""ΤȤ
     *                  ','ˤʤޤ
     * @exception Exception tablenullä
     *                      եˤʤꤲޤ
     */
    static public void outputFileFromTable(DefaultTableModel model,
					   String FileName,
					   String Separator)
	throws IOException,
	       IllegalArgumentException,
	       FileNotFoundException,
	       SecurityException
    {
	logger.debug("outputFileFromTable - entering ");
	// ޤǤ뤫å
	if (model == null||FileName == null)
	    {
		throw new IllegalArgumentException();
	    }
	
	// separatorå
	if (Separator == null||Separator.equals(""))
	    {
		Separator = ",";
	    }
	
	int column = model.getColumnCount();
	int row = model.getRowCount();
	// Ԥοå
	if (column == 0||row == 0)
	    {
		throw new IllegalArgumentException();
	    }
	
	BufferedOutputStream outFile;
	
	logger.debug("outputFileFromTable - open " + FileName);
	// ե򳫤񤭹
	PrintWriter out = 
	    new PrintWriter(new OutputStreamWriter(new FileOutputStream(FileName), "UTF-8"));
	
	// 
	// ޤHeadColumn
	for (int j = 0;j < column;j ++)
	    {
		logger.debug("outputFileFromTable - write \"" +
			     (String)model.getColumnName(j) + "\"");
		out.print((String)model.getColumnName(j));
		// Separator
		if (j != column - 1)
		    {
			logger.debug("outputFileFromTable - write separator");
			out.print(Separator);
		    }
		// Ԥ
		else
		    {
			logger.debug("outputFileFromTable - write LF");
			out.print("\n");
		    }
	    }
	
	// 
	for (int i = 0;i < row;i ++)
	    {
		for (int j = 0;j < column;j ++)
		    {
			out.print((String)model.getValueAt(i, j));
			// Separator
			if (j != column - 1)
			    {
				out.print(Separator);
			    }
			// Ԥ
			else
			    {
				out.print("\n");
			    }
		    }
	    }
	out.close();
	return ;
    }
    
    static public void saveConfig(Vector dest,
				  Vector exp, Vector exp2, Vector exp3,
				  Component component)
	throws IOException,
	       IllegalArgumentException,
	       FileNotFoundException,
	       SecurityException
    {
	String fileName = getFilenameFromUser(component, "Save");
	if (fileName.equals(""))
	    throw new IllegalArgumentException();
	saveConfig(dest, exp, exp2, exp3, fileName);
	return ;
    }

    private static final String ROOT_NAME = "ankouConfig";
    
    /**
     * 
     * @param dest о
     * @param exp Ｐ
     * @param fileName ¸Υե
     * @exception Exception tablenullä
     *                      եˤʤꤲޤ
     */
    static public void saveConfig(Vector dest,
				  Vector exp, Vector exp2, Vector exp3,
				  String fileName)
	throws IOException,
	       IllegalArgumentException,
	       FileNotFoundException,
	       SecurityException
    {
	logger.debug("saveConfig - open " + fileName);
	Document document = null;
	try
	    {
		// DOM 
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance(); 
		DocumentBuilder builder = factory.newDocumentBuilder(); 
		DOMImplementation domImpl = builder.getDOMImplementation();
		document = domImpl.createDocument("", ROOT_NAME, null);
	    }
	// ä麤롣
	catch (javax.xml.parsers.ParserConfigurationException e)
	    {
		throw new IllegalArgumentException();
	    }
	
	// о
	Element tagNode = document.createElement("dest");
	document.getDocumentElement().appendChild(tagNode);
	for (int i = 0;i < dest.size();i ++)
	    {
		Element location = document.createElement("location");
		Text text = document.createTextNode((String)dest.get(i));
		tagNode.appendChild(location);
		location.appendChild(text);
	    }
	 
	 //  exp(Node) exp2(String)
	Element expNode = document.createElement("exp");
	document.getDocumentElement().appendChild(expNode);
	for (int i = 0;i < exp.size();i ++)
	    {
		Element location = document.createElement("JTree");
		location.setAttribute("type", (String)exp2.get(i));
		location.setAttribute("place", (String)exp3.get(i));
		location.appendChild(document.importNode((Node)exp.get(i), true));
		expNode.appendChild(location);
	    }
	
	try
	    {
		javax.xml.transform.TransformerFactory tff = javax.xml.transform.TransformerFactory.newInstance();
		Transformer tf = tff.newTransformer();
		javax.xml.transform.dom.DOMSource src = new DOMSource();
		src.setNode(document);
		javax.xml.transform.stream.StreamResult target =
		    new javax.xml.transform.stream.StreamResult(new File(fileName));
		tf.setOutputProperty(OutputKeys.INDENT, "yes");
		tf.setOutputProperty(OutputKeys.ENCODING, "UTF-8");
		tf.transform(src, target);
	    }
	catch(Exception e)
	    {
		throw new IllegalArgumentException();
	    }

	return ;
    }
    
    static public Vector loadConfig(Component component)
	throws IOException,
	       IllegalArgumentException,
	       FileNotFoundException,
	       SecurityException,
	       ParserConfigurationException,
	       SAXException
    {
	String fileName = getFilenameFromUser(component, "Open");
	if (fileName.equals(""))
	    throw new IllegalArgumentException();
	return loadConfig(fileName);
    }
    
    /**
     * @param fileName ɤ߹ե
     * @exception Exception եɤʤꤲޤ
     */
    static public Vector loadConfig(String fileName)
	throws IOException,
	       IllegalArgumentException,
	       FileNotFoundException,
	       SecurityException,
	       ParserConfigurationException,
	       SAXException
    {
	logger.debug("loadConfig - file: " + fileName);
	
	Vector configV = new Vector();
	Vector destV = new Vector();
	Vector expV = new Vector();
	Vector expV2 = new Vector();
	Vector expV3 = new Vector();
	
	DocumentBuilderFactory factory =
	    DocumentBuilderFactory.newInstance();
	DocumentBuilder builder = factory.newDocumentBuilder();

	// childNodeˤϡdestexpϤǤ
	
	Node root = builder.parse("file:///" + fileName).getFirstChild();
	NodeList children = root.getChildNodes();
	
	for (int i = 0;i < children.getLength(); i++)
	    {
		Node child = children.item(i);
		NodeList element = child.getChildNodes();

		logger.debug("loadConfig - . node: " + child.getNodeName() + " " + element.getLength());
		
		if (child.getNodeName().equals("dest"))
		    {
			for (int j = 0;j < element.getLength();j ++)
			    {
				Node item = element.item(j);
				NodeList list = item.getChildNodes();
				if (item.getNodeName().equals("location"))
				    {
					String s = list.item(0).getNodeValue();
					logger.debug("loadConfig - .. " + s);
					destV.add(s);
				    }
			    }
		    }
		else if (child.getNodeName().equals("exp"))
		    {
			for (int j = 0;j < element.getLength();j ++)
			    {
				Node item = element.item(j);
				NodeList list = item.getChildNodes();
				if (item.getNodeName().equals("JTree"))
				    {
					logger.debug("loadConfig - . " + item.getAttributes());
					for (int l = 0;l < list.getLength();l ++)
					    {
						if (list.item(l).getNodeName().equals("TreeNode"))
						    {
							logger.debug("loadConfig - .. " + list.item(l));
							expV.add(list.item(l));
							NamedNodeMap map = item.getAttributes();
							expV2.add(map.getNamedItem("type").getNodeValue());
							expV3.add(map.getNamedItem("place").getNodeValue());
						    }
					    }
				    }
			    }
		    }
	    }
	
	// ...
	configV.add(destV);
	configV.add(expV);
	configV.add(expV2);
	configV.add(expV3);
	logger.debug("loadConfig - _ " + expV + expV2 + expV3);
	return configV;
    }
}
