// Tamino Qizx/Open Interface
// Copyright (C) 2004 Teru KAMOGASHIRA

package jp.go.kokken.Ankou;

import org.apache.log4j.Logger;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.dm.*;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.impl.*;
import net.xfra.qizxopen.xquery.dm.*;
import net.xfra.qizxopen.xquery.fn.*;

import java.io.*;

/**
 * եФ븡饤֥Qizx/Openδؿ(Threadб)
 *
 * <p>Υ饹ϥ˥ʻȤThreadŪʻȤξ
 * ݡȤޤ</p>
 * <p>ȤơWindowsξdoc("")ˤC:\ǤʤC|\Ǥʤ
 * 顼Ф뤳Ȥޤ</p>
 * <p>ޤ̤λȤˤĤƽҤ٤ޤ</p>
 * <pre>
 * // Τ
 * String r = null; QizxOpen qizx = new QizxOpen();
 * // QueryФ
 * try {
 *   r = qizx.submitQuery("XQuery ʸ");
 * } catch (Exception e) {
 *   System.err.println(qizx.getExceptionString());
 * }
 * </pre>
 * <p>ThreadȤƻȤȤ򼨤ޤ</p>
 * <pre>
 * // Τ
 * String r = null; QizxOpen qizx = new QizxOpen();
 * // QUERYʸϿ<br/>
 * qizx.registerQuery("XQuery ʸ");
 * // Thread¹Ԥޤ
 * qizx.start();
 * // ԤޤTimerѤƤ⤤Ǥ礦
 * try {
 *   qizx.join();
 * } catch(...
 * }
 * // ޤ
 * if (qizx.checkResult()) {
 *   // 
 *   // ʸФޤ
 *   System.out.println(qizx.getResultString());
 * } else {
 *   System.out.println(qizx.getExceptionString());
 * }
 * </pre>
 */
public class QizxOpen
    extends QueryDriver
{
    /**
     * Qizx/OpenȤHandler
     */
    StringWriter resultwriter = null;
    PrintWriter logwriter = null;
    
    /**
     * Ƥ<code>true</code>
     * ʳξ<code>false</code>ݻ
     */
    boolean success = false;
    
    /**
     * QUERY饤֥ޤ
     */
    public QizxOpen()
    {
	super();
	logger = Logger.getLogger(QizxOpen.class);
	resultwriter = new StringWriter();
	logwriter = new PrintWriter((Writer)errwriter);
	return ;
    }
    
    /**
     * Qizx/OpenΥС
     */
    public String getVersion()
    {
	return net.xfra.qizxopen.xquery.impl.Version.get();
    }
    
    /**
     * XQuery饤֥Ǽ¹Ԥޤ̾ThreadȤƼ¹Ԥޤ
     * @param QueryString XQueryʸ nullΤȤϿ줿ʸ
     *                    ¹Ԥޤ
     * @exception Exception 顼ˤϤĤExceptionޤ
     *            getExceptionString()ʸФƲ
     * @return μ¹Է̤ʸǤ
     */
    public String submitQuery(String queryString)
	throws java.io.IOException,
	       IllegalArgumentException,
	       java.lang.OutOfMemoryError
    {
	logger.debug("submitQuery - entering ");
	
	Log log =  new Log(logwriter);
	
	if (queryString != null)
	    {
		qstring = queryString;
	    }
	else
	    {
		logger.debug("submitQuery - QueryString was replaced with registered query string. (QueryString was null.)");
	    }
	
	logger.debug("submitQuery - QueryString:\n======\n"
		     + qstring
		     + "\n======\n");

	try
	    {
		XQueryProcessor processor = new XQueryProcessor("file://", "file://");
		resultwriter.close();
		resultwriter.flush();
		errwriter.close();
		errwriter.flush();
		logwriter.close();
		logwriter.flush();
		
		// Compile query
		log.reset();
		XQuery query =
		    processor.compileQuery(qstring, "<source>", log);
		log.flush();
		if(log.getErrorCount() != 0)
		    {
			logger.error("submitQuery - parse/static error ErrorCount=" + log.getErrorCount());
			
			errwriter.write(log.getErrorCount() + " parsing/static error(s)\n");
			throw new IllegalArgumentException();
		    }
		
		XMLSerializer serial = new XMLSerializer(); 
		
		// execute query
		serial.setOutput((Writer)resultwriter);
		serial.setOption("method", "XML");
		serial.setOption("indent", "yes");
		serial.setOption("encoding", "UTF-8");
		processor.executeQuery(query, serial);
	    }
	catch (XQueryException e)
	    {
		logger.error("submitQuery - XQueryException " + e);
		
		errwriter.write("*** " + e.getMessage());
		throw new IllegalArgumentException();
	    }
	catch (DataModelException e)
	    {
		logger.error("submitQuery - DataModelException " + e);
		
		errwriter.write("*** " + e.getMessage());
		throw new IllegalArgumentException();
	    }
	catch (java.lang.OutOfMemoryError e)
	    {
		logger.error("submitQuery - java.lang.OutOfMemoryError" + e);
		throw new java.lang.OutOfMemoryError();		
	    }
	success = true;
	
	logger.debug("submitQuery - exiting ");
	return (rstring = resultwriter.toString());
    }
}
