// Tamino XQuery Interface
// Copyright (C) 2004 Teru KAMOGASHIRA

package jp.go.kokken.Ankou;

import java.util.regex.*;
import java.util.*;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.tree.*;
import javax.swing.text.*;

/**
 * Easy QueryCompiler
 * Compile Japanese Query into XQuery-like form.<br>
 *
 * ĥ꡼¤ʸäꤽ줾ξʸ
 * ɬפȤʤstaticؿ򤤤Ƥޤ
 * 줾̣򤷤ƻȤäƲʤΥ饹TODO
 */
public class QueryCompiler
{
    public QueryCompiler()
    {
    }
    
    /**
     * Ƭnot(ȿ)ʸ󤫤ޤ<br/>
     * If it does not contains &quot;not (&quot;
     * at the head of the NodeString this returns
     * NodeString (same string).
     * @param NodeString ʸ
     * @return string between &quot;not (&quot; and &quot;)&quot;.
     *                ϤޤƤʤϤΤޤ֤ޤ
     */
    public static String getExpressionString(String nodeString)
    {
	// removes "not (" + ")" in the NodeString
	if (checkNotString(nodeString).equals("not"))
	    {
		// ex. not (@Ĺñ(LUWLemma) = 'ܸ')
		return nodeString.substring(5, nodeString.length()-1);
	    }
	else
	    {
		return nodeString;
	    }
    }    
    
    /**
     * ʸʸǤ뤫Ĵ٤ޤ
     * @param nodeString ʸ
     * @return &quot;not&quot; if the head of the nodeString is
     *          &quot;not (&quot;. Otherwise, this returns &quot;yes&quot;.
     */
    public static String checkNotString(String nodeString)
    {
	// returns not if nodeString is "Not expression",
	// otherwise, return "yes".
	if (nodeString.length() < 3)
	    return "";
	if (nodeString.substring(0, 3).equals("not"))
	    {
		return "not";
	    }
	else
	    {
		return "yes";
	    }
    }
    
    /**
     * XQueryξʸǤ°̾Фޤ
     * @param nodeString ʸ
     * @return attibutes name in the nodeString
     *         ex.@example=&quot;string&quot; -> 
     *         &quot;example&quot; will be returned.
     */
    public static String getAttributeName(String nodeString)
    {
	String temp = getExpressionString(nodeString);
	String exp = getExpression(temp);
	
	// extract first @..(..) (<- buggy?)
	Pattern pattern;
	Matcher matcher;
	pattern = Pattern.compile("@.* " + exp);
	matcher = pattern.matcher(nodeString);
	if (matcher.find())
	    {
		temp = matcher.group(0);
		return temp.substring(1, temp.length()-exp.length()-1);
	    }
	else
	    {
		return "";
	    }
    }
    
    /**
     * XQueryξʸǤͤФޤ
     * @param nodeString ʸ
     * @return attibute's value in the nodeString
     *         ex.@example=&quot;string&quot; -> 
     *         &quot;string&quot; will be returned.
     */
    public static String getValue(String nodeString)
    {
	String temp = getExpressionString(nodeString);
	String exp = getExpression(temp);
	
	Pattern pattern;
	Matcher matcher;
	pattern = Pattern.compile(exp + " .*");
	matcher = pattern.matcher(temp);
	if (matcher.find())
	    {
		temp = matcher.group(0);
		return temp.substring(exp.length()+1);
	    }
	else
	    {
		return "";
	    }
    }
    
    /**
     * ()ʸФޤ
     * @param nodeString ʸ
     * @return ĤФʸ󡢤Ǥʤʤnull֤ޤ
     */
    public static String getInsideBrace(String nodeString)
    {
	String temp = getExpressionString(nodeString);

	Pattern pattern;
	Matcher matcher;
	pattern = Pattern.compile("\\(.*\\)");
	matcher = pattern.matcher(temp);
	if (matcher.find())
	    {
		temp = matcher.group(0);
		return temp.substring(1, temp.length()-1);
	    }
	else
	    {
		return "";
	    }
    }
    
    /**
     * XQueryＰǱѸ°̾ηˤޤ
     * @param nodeString ʸ
     * @param prefix @ˤĤʸ
     * @return not (@ܸ(LUW) = &quot;⤤&quot;) 
     *         not (prefix@LUW = &quot;⤤&quot;)ˤʤޤ
     */
    public static String getEngExpression(String nodeString, String prefix)
    {
	if (prefix == null)
	    {
		prefix = "";
	    }
	String attrname = "";
	String temp = QueryCompiler.getAttributeName(nodeString);
	String exp = QueryCompiler.getExpression(nodeString);
	String value = QueryCompiler.getValue(nodeString);
	
	attrname = getInsideBrace(temp);
	
	if (QueryCompiler.checkNotString(nodeString).equals("not"))
	    {
		return "not (" + prefix + "@" + attrname + " " + exp + " " +
		    value + ")";
	    }
	else
	    {
		return prefix + "@" + attrname + " " + exp + " " + value;
	    }
    }
    
    /**
     * XQueryξʸǤξＰʸФޤ
     * @param nodeString ʸ
     * @return attibute's value in the nodeString
     *         ex.@example=&quot;string&quot; -> 
     *         &quot;=&quot; will be returned.
     */
    public static String getExpression(String nodeString)
    {
	String temp = getExpressionString(nodeString);
	// This order is important.
	// Ex. You must find "!=" before "="
	String[] expressions = {"!=", ">=", "<=", "=", ">", "<",};
	
	for (int i = 0;i < expressions.length;i ++)
	    {
		if (temp.indexOf(expressions[i]) != -1)
		    return expressions[i];
		if (i >= expressions.length)
		    return "";
	    }
	return "";
    }

    public static String buildXQueryString(DefaultMutableTreeNode docNode,
					   UIElement[][] elementMatrix,
					   UISelect[][] selectMatrix,
					   String rootNodeString, int from,
					   String hiddenString)
    {
	// ޤＰɽΤ¸ߤ뤫Τᡢ(ֿͥ)
	VectorV elementV = searchDepthOfTree((DefaultMutableTreeNode)docNode.getChildAt(0), elementMatrix);
	VectorV selectV = searchDepthOfTree((DefaultMutableTreeNode)docNode.getChildAt(0), selectMatrix);
	int depth = Math.max(elementV.size(),selectV.size());
	VectorV lV = null;
		
	String qstring = "";
	// Τ֤forͥȡۤƤ
	// ̤٤르ꥺ for qizx/open
	if (depth <= 7)
	    {
		// for $Talk in $rootNodeString/Talk
		// [where -]
		// return ....
		String previousNodeName = rootNodeString;
		for (int i = from;i < depth;i ++)
		    {
			String currentNodeName = null;
			if (elementV.size() > selectV.size())
			    currentNodeName = ((UIElement)elementV.get(i)).elementString;
			else
			    currentNodeName = ((UISelect)selectV.get(i)).elementString;
			qstring = qstring +
			    "for $" + currentNodeName + " in " + previousNodeName + "/" + currentNodeName + "\n";
			if (i < elementV.size())
			    {
				if (!elementV.get(i).toString().equals(""))
				    {
					qstring = qstring +
					    "where " + ((UIElement)elementV.get(i)).toXQueryString("$" + currentNodeName + "/") + "\n";
				    }
			    }
			qstring = qstring + "return\n";
			previousNodeName = "$" + currentNodeName;
		    }
		qstring = qstring + "<item>\n" + hiddenString;
		for (int i = from;i < selectV.size();i ++)
		    {
			UISelect uiS = (UISelect)selectV.get(i);
			String currentNodeName = uiS.elementString;
			qstring = qstring +
			    uiS.buildStringFromList("\t<" + currentNodeName + "> {$" + currentNodeName + "/", "} </" + currentNodeName + ">", "", 1);
		    }
		qstring = qstring + "</item>";
	    }
	else
	    {
	    }
	
	return qstring;
    }
    
    private static VectorV searchDepthOfTree(DefaultMutableTreeNode node,
					     Object[][] o)
    {
	VectorV v = new VectorV();
	int[] place = SchemeLoader.getElementPlace((String)node.getUserObject());
	String currentNode = ((Object)(o[place[0]][place[1]])).toString();
	if (!node.isLeaf())
	    {
		for (int i = 0;i < node.getChildCount();i ++)
		    {
			DefaultMutableTreeNode childTreeNode =
			    (DefaultMutableTreeNode)node.getChildAt(i);
			if (childTreeNode != null)
			    {
				VectorV cv = searchDepthOfTree(childTreeNode, o);
				if (v.size() < cv.size())
				    v = cv;
			    }
		    }
	    }
	if (v.size() != 0||!currentNode.equals(""))
	    {
		v.add(0, o[place[0]][place[1]]);
	    }
	
	return v;
    }
}

class VectorV extends java.util.Vector
{
    public boolean addFromVector(Vector v)
    {
        if (v == null)
            return false;
        for (int i = 0;i < v.size();i ++)
            {
                this.add(v.get(i));
            }
        return true;
    }
}
