// Tamino Query Driver Interface
// Copyright (C) 2004 Teru KAMOGASHIRA

package jp.go.kokken.Ankou;

import org.apache.log4j.Logger;

import java.io.*;

/**
 * ɥ饤
 */

public abstract class QueryDriver
    extends Thread
{
    /**
     * log4j logger
     */
    static Logger logger = null;
    
    /**
     * Ƥ<code>true</code>
     * ʳξ<code>false</code>ݻ
     */
    protected boolean success;
        
    protected StringWriter errwriter;
    protected String qstring;
    protected String rstring;

    /**
     * QUERY饤֥ޤ
     */
    protected QueryDriver()
    {
	errwriter = new StringWriter();
	success = false;
    }
    
    /**
     * DriverΥС
     */
    abstract public String getVersion();

    /**
     * QUERYThread
     */
    public void run()
    {
	logger.debug("run - entering ");
	
	try
	    {
		submitQuery(null);
	    }
	catch (Exception e)
	    {
		logger.error("run - Exception " + e);
		errwriter.flush();
		errwriter.write(e.toString());
		e.printStackTrace();
		success = false;
		return ;
	    }
	
	if (Thread.currentThread().isInterrupted())
	    {
		logger.error("run - Interrupted ");
		
		success = false;
		return ;
	    }
	success = true;
	
	logger.debug("run - exiting ");
	return ;
    }

    /**
     * äĴ٤ޤ
     * @return ʤtrueʳξfalse֤ޤ
     */
    public boolean checkResult()
    {
	return success;
    }
    
    /**
     * ¹Է̤ʸФޤ
     * @return ƤϷ̤ʸ󡢤ʳξ
     *         null֤ޤ
     */
    public String getResultString()
    {
	return rstring;
    }
    
    /**
     * 㳰ʸФޤ
     * @return ԤƤϥ顼ʸƤ
     *         null֤ޤ
     */
    public String getExceptionString()
    {
	return errwriter.toString();
    }
    
    /**
     * XQueryϿޤδؿ
     * Thread¹ԤˤƲ
     * @param QueryString XQueryʸ
     */
    public void registerQuery(String queryString)
    {
	qstring = queryString;
    }
    
    /**
     * XQuery饤֥Ǽ¹Ԥޤ̾ThreadȤƼ¹Ԥޤ
     * @param QueryString XQueryʸ nullΤȤϿ줿ʸ
     *                    ¹Ԥޤ
     * @exception Exception 顼ˤϤĤExceptionޤ
     *            getExceptionString()ʸФƲ
     * @return μ¹Է̤ʸǤ
     */
    abstract public String submitQuery(String queryString)
	throws IOException,
	       IllegalArgumentException,
	       java.lang.OutOfMemoryError;
}
