// Copyright (C) 2004 Teru KAMOGASHIRA

package jp.go.kokken.Ankou;

import org.apache.log4j.Logger;
import org.apache.log4j.BasicConfigurator;

import java.util.Vector;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*;
import javax.swing.tree.*;
import java.net.*;
import java.io.*;

/**
 * ᥤWINDOWΥ饹
 *
 * <p>ե뤢뤤TaminoФƸ¹Ԥ륯饤ȤǤ
 * TaminoФ³ʤƤեФ븡ϼ¹ԤǤޤ</p>
 *
 * <p>ʲϥޥɥ饤󥪥ץǤ</p>
 * <ul>
 * <li>-d о</li>
 * <li>-f Ƥäե</li>
 * <li>-o ̤ν</li>
 * <li>-batch ư⡼</li>
 * <li>-log4j log4j.propertiesեꤹ</li>
 * </ul>
 *
 */
public class TaminoClient
    extends javax.swing.JFrame
    implements java.awt.event.ActionListener
{
    public final static String VERSION = "1.1";
    public final static String REQUIRED_VERSION = "1.4";
    
    /**
     * log4j logger
     */
    static Logger logger =
	Logger.getLogger(TaminoClient.class);
    
    static TaminoClient app;
    static Client client;
    
    static SchemeLoader loader = null;
    static UIDestSelect dest = null;
    static CompileResults resultTab = null;    
    static UIPlay playU = null;
    
    private static AnkouSplash splash = null;
    
    // to toggle Connection/Disconnection.
    static JMenuItem item21;
    static JMenuItem item22;
    
    // to toggle submit
    static JMenuItem item42;

    //static JEditorPane html = null;
    static JTextArea message = null;
    static JTextArea ret = null;
    
    static Vector elementList = null;
    static Vector selectList = null;
    
    UIElement[][] elementMatrix = null;
    UISelect[][] selectMatrix = null;
    DefaultMutableTreeNode docStructNode = null;    
    /**
     * ᥤWindowȥץԤʤޤ
     */
    public TaminoClient()
    {
        /* specify what to do when [X] was clicked or EXIT is send */
	addWindowListener(new WindowAdapter()
	    {
                public void windowClosing(WindowEvent evt)
		{
		    int value =
			JOptionPane.showConfirmDialog(getContentPane(),
						      "λޤ",
						      "exit",
						      JOptionPane.YES_NO_OPTION);
		    
		    if (value == JOptionPane.YES_OPTION)
			{
			    System.exit(0);
			}
		    else
			{
			    app = new TaminoClient();
			    
			    // Place window at the center.
			    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
			    Dimension frameSize = app.getSize();
			    if (frameSize.height > screenSize.height)
				{
				    frameSize.height = screenSize.height;
				}
			    if (frameSize.width > screenSize.width)
				{
				    frameSize.width = screenSize.width;
				}
			    app.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
			    
			    app.setVisible(true);
			}
                }
            }
			  );
	
	setTitle("Ankou " + VERSION);
	
	// Setup Menubar
	// MenuBar
	// [File][Server][Query][Help]

	JMenuBar menuBar = new JMenuBar();
	JMenu menu1 = new JMenu("ե");
	JMenu menu2 = new JMenu("о", false);
	JMenu menu4 = new JMenu("", false);
	JMenu menu3 = new JMenu("إ", false);
	menuBar.add(menu1);
	menuBar.add(menu2);
	menuBar.add(menu4);
	menuBar.add(menu3);
	
	// Each Menu
	// [File]-[Exit]
	// [Server]-[Connect]/[Disconnect]
	// [Query]-[Clear]/[Submit]
	// [Help]-[About]
	
	JMenuItem item130 = new JMenuItem("Ƥ¸");
	menu1.add(item130);
	JMenuItem item140 = new JMenuItem("Ƥɤ߹");
	menu1.add(item140);
	
	JMenu item12 = new JMenu("̤¸");
	menu1.add(item12);
	JMenuItem item121 = new JMenuItem("CSVȤ¸");
	item12.add(item121);
	JMenuItem item122 = new JMenuItem("XMLȤ¸");
	item12.add(item122);

	JMenuItem item11 = new JMenuItem("λ");
	menu1.add(item11);
	
	item21 = new JMenuItem("оݤ");
	menu2.add(item21);
	
	item42 = new JMenuItem("¹");
	menu4.add(item42); 
	
	JMenuItem item32 = new JMenuItem("AnkouˤĤ");
	menu3.add(item32);

	item130.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_S, ActionEvent.CTRL_MASK));
	item130.setActionCommand("saveConfig");
        item130.addActionListener(this);
	
	item140.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_O, ActionEvent.CTRL_MASK));
	item140.setActionCommand("loadConfig");
        item140.addActionListener(this);
	
	item121.setActionCommand("saveOutputAsCSV");
        item121.addActionListener(this);
	
	item122.setActionCommand("saveOutputAsXML");
        item122.addActionListener(this);

	item11.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_Q, ActionEvent.CTRL_MASK));
	item11.setActionCommand("Exit");
        item11.addActionListener(this);

	item21.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_C, ActionEvent.CTRL_MASK));
	item21.setActionCommand("ConfigureDest");
        item21.addActionListener(this);

	item42.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_R, ActionEvent.CTRL_MASK));
	item42.setActionCommand("Submit");
        item42.addActionListener(this);

	item32.setActionCommand("About");
        item32.addActionListener(this);
	
	this.setJMenuBar(menuBar);	
	
	// -----
	// TabbedPane
	// [Message][Query][Return][Output]
	// [Text][Text][Text][HTML]
	JTabbedPane tab = new JTabbedPane();
	tab.setTabLayoutPolicy(JTabbedPane.SCROLL_TAB_LAYOUT);
	
	JPanel messagePanel = new JPanel(new BorderLayout());
	JPanel queryPanel = new JPanel(new BorderLayout());
	JPanel selectPanel = new JPanel(new BorderLayout());
	JPanel outputPanel = new JPanel(new BorderLayout());
	
	// Message Panel
	message = new JTextArea("Ankou å\n\n");
	message.setEditable(false);
	message.setTabSize(4);
	
	messagePanel.add(new JScrollPane(message));

	// 浪ɽоݤꤹ륿֤
	// 뤿ˤޤCVS꥽⤫ɤ߹ߤޤ
	
	// read XML scheme and load them into elementList
	// make new UIElement for Talk, IPU, ...
	
	loader = null;
	try
	    {
		loader =
		    new SchemeLoader(new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/jp/go/kokken/Ankou/Tree.utf16"),
									      "UTF-16")));
	    }
	catch (java.io.IOException e)
	    {
		JOptionPane.showMessageDialog(getContentPane(),
					      "CVSޥեɹ˼Ԥޤ\n⤷Tree.utf16Խʤ顢javadoc/jp/go/kokken/Ankou/SchemeLoader.html򸫤Τ˽񤭤ʤƲ");
		System.exit(-1);
	    }
	
	// UIElement/UISelect Ͽ
	// Ʊ˥åɤκ롣
	elementList = new Vector();
	selectList = new Vector();
	int gridDepthMax = 0, gridYmax = 0;
	for (int i = 0;i < loader.getNumberOfElements();i ++)
	    {
		String elementName = loader.getElementName(i);
		int[] place = loader.getElementPlace(i);
		elementList.add(new UIElement(place[0], place[1],
					      elementName,
					      loader.getJapaneseTreeName(elementName),
					      loader.getEnglishTextVector(elementName),
					      loader.getJapaneseTextVector(elementName))
				);
		
		selectList.add(new UISelect(place[0], place[1],
					    elementName,
					    loader.getJapaneseTreeName(elementName),
					    loader.getEnglishTextVector(elementName),
					    loader.getJapaneseTextVector(elementName))
			       );

		if (gridDepthMax < place[0])
		    gridDepthMax = place[0];
		if (gridYmax < place[1])
		    gridYmax = place[1];
	    }
	
	// the grid = (xmax*4)*(ymax)
	/*
	 * 0       1 2 3
	 * Button [TextArea]
	 * Talk [  ]
	 *      [  ]
	 * IPU  [  ]
	 *      [  ]
	 * LUW  [  ] Noise [  ]
	 * ...
	 * ^------------------^ <- There are 2 elements (xmax=2)
	 * 
	 */
       	
	// ok, then add UI-Component.
	// gridx 0~
	// gridy 0~
	// gridwidth
	// gridheight
	GridBagConstraints gbc = new GridBagConstraints();	
	
	GridBagLayout gridBagQuery = new GridBagLayout();
	queryPanel.setLayout(gridBagQuery);
	GridBagLayout gridBagSelect = new GridBagLayout();
	selectPanel.setLayout(gridBagSelect);
	
	// Ʊ˥ޥȥåǥǤUIElement/UISelect
	elementMatrix = new UIElement[gridDepthMax+1][gridYmax+1];
	selectMatrix = new UISelect[gridDepthMax+1][gridYmax+1];
	for (int x = 0;x <= gridDepthMax;x++)
	    {
		for (int y = 0;y <= gridYmax;y++)
		    {
			elementMatrix[x][y] = null;
			selectMatrix[x][y] = null;
		    }
	    }
	
	// tempolary UIElement
	UIElement uielement;
	// tempolary UISelect
	UISelect uiselect;
	
	for (int i = 0;i < loader.getNumberOfElements();i ++)
	    {
		uielement = (UIElement)elementList.get(i);
		uiselect = (UISelect)selectList.get(i);
		elementMatrix[uielement.depth][uielement.number] = uielement;
		selectMatrix[uielement.depth][uielement.number] = uiselect;
		// add button
		gbc.gridx = 4 * uielement.number;
		gbc.gridy = 2 * uielement.depth;
		gbc.gridwidth  = 1;
		gbc.gridheight = 1;
		gbc.weightx = 0.3;
		gbc.weighty = 0.3;
		gbc.insets = new Insets(4, 4, 4, 4);
		gbc.fill = GridBagConstraints.HORIZONTAL;
		//
		gridBagQuery.setConstraints(uielement.elementButton, gbc);
		queryPanel.add(uielement.elementButton);
		//
		gridBagSelect.setConstraints(uiselect.elementButton, gbc);
		selectPanel.add(uiselect.elementButton);
		// add TextArea (ɽ)
		gbc.gridx = 1 + 4 * uielement.number;
		gbc.gridy = 2 * uielement.depth;
		gbc.gridwidth  = 3;
		gbc.gridheight = 2;
		gbc.weightx = 1.7;
		gbc.weighty = 1.7;
		gbc.insets = new Insets(4, 4, 4, 4);
		gbc.fill = GridBagConstraints.BOTH;
		gridBagQuery.setConstraints(uielement.inputArea, gbc);
		queryPanel.add(uielement.inputArea);
		gridBagSelect.setConstraints(uiselect.inputArea, gbc);
		selectPanel.add(uiselect.inputArea);
	   }
	
	// ʸ¤δʰץĥ꡼
	DefaultMutableTreeNode[][] nodeMatrix = new DefaultMutableTreeNode[gridDepthMax+1][gridYmax+1];
	docStructNode = new DefaultMutableTreeNode("root");
	
	for (int i = 0;i <= gridDepthMax;i ++)
	    {
		for (int j = 0;j < gridYmax;j ++)
		    {
			if (elementMatrix[i][j] != null)
			    {
				// depth0ǤϤ٤ƤTagrootν°
				if (i == 0)
				    {
					docStructNode.insert((nodeMatrix[i][j] =
							      new DefaultMutableTreeNode(i + "," + j)),
							     docStructNode.getChildCount());
					logger.debug("TaminoClient - " + i + "," + j + "-> root");
				    }
				else
				    {
					// ľˤȤޤǸĤޤõ
					find_s: for (int k = j;k >= 0;k --)
					    {
						if (elementMatrix[i-1][k] != null)
						    {
							nodeMatrix[i-1][k].insert((nodeMatrix[i][j] = new DefaultMutableTreeNode(i + "," + j)),
										  nodeMatrix[i-1][k].getChildCount());
							logger.debug("TaminoClient - " + i + "," + j + "->" +
								     (i-1) + "," + k);
							break find_s;
						    }
					    }
				    }
			    }
		    }
	    }
	
	// Output Panel
	outputPanel.add(new JScrollPane(resultTab.table));
	
	// ơ֥򥯥åư (inner classǤäȸˤ)
	resultTab.table.addMouseListener(new MouseAdapter()
	    {
		JPopupMenu popup;

		private void setupPopup()
		{
		    popup = new JPopupMenu();
		    JMenuItem menuItem1 = new JMenuItem("");
		    menuItem1.setActionCommand("playSelectedRow");
		    menuItem1.addActionListener(app);
		    popup.add(menuItem1);
		    JMenuItem menuItem2 = new JMenuItem("ʪIPUɽ");
		    menuItem2.setActionCommand("openSelectedRowInMnfc");
		    menuItem2.addActionListener(app);
		    popup.add(menuItem2);
		}
		
		public void mousePressed(MouseEvent e)
		{
		    setupPopup();
		    if (e.isPopupTrigger())
			{
			    popup.show(e.getComponent(), e.getX(), e.getY());
			}
		    
		    if (e.getClickCount() == 1)
			{
			    JTable table = (JTable)e.getSource();
			    logger.debug("mousePressed - 1 " + table.getSelectedRow());
			}
		    else if (e.getClickCount() == 2)
			{
			    JTable table = (JTable)e.getSource();
			    logger.debug("mousePressed - 2 " + table.getSelectedRow());
			    playSelectedRow(table.getSelectedRow());			    
			}
		}
	    }
					 );
	
	// Install tabs

	tab.add("å", messagePanel);
	tab.add("", queryPanel);
	tab.add("ɽΤ", selectPanel);
	tab.add("Output", outputPanel);
	

	this.getContentPane().add(tab, BorderLayout.CENTER);
	
        setSize(800,600);
    }

    /**
     * ꤵ줿Ԥʪǳ
     */
    private void openSelectedRowInMnfc(int row)
    {
	String ipuID = null;
	logger.debug("openSelectedRowInMnfc - filename = "
		     + resultTab.getHiddenAttribute("DOC/@name", row));
	logger.debug("openSelectedRowInMnfc - ipu = "
		     + (ipuID = resultTab.getHiddenAttribute("IPU/@IPUID", row)));
	// trn
	String xmlFilename = 
	    resultTab.getHiddenAttribute("DOC/@name", row);
	String trnFilename =
	    xmlFilename.substring(0, xmlFilename.length()-3) + "trn";
	String command = "mnfc";
	try
	    {
		Process process = Runtime.getRuntime().exec(command + " " + trnFilename + " -ipu " +
							    resultTab.getHiddenAttribute("IPU/@IPUID",
										 row));
	    }
	catch (java.io.IOException e)
	    {
		logger.error("openSelectedRowInMnfc - ipu = " + e);
	    }
    }
    
    /**
     * ꤵ줿Ԥ
     */
    private void playSelectedRow(int row)
    {
	logger.debug("playSelectedRow - filename = "
		     + resultTab.getHiddenAttribute("DOC/@name", row));
	logger.debug("playSelectedRow - from = "
		     + resultTab.getHiddenAttribute("IPU/@IPUStartTime", row));
	logger.debug("playSelectedRow - to = "
		     + resultTab.getHiddenAttribute("IPU/@IPUEndTime", row));
	// ե*.xml-xml+wav/WAV餷
	// äWindowsϿۡwav?Wav?WAV?
	String xmlFilename = 
	    resultTab.getHiddenAttribute("DOC/@name", row);
	String wavFilename =
	    xmlFilename.substring(0, xmlFilename.length()-3) + "wav";
	double start = 0;
	double end = 0;
	try
	    {
		start =
		    Double.parseDouble(resultTab.getHiddenAttribute("IPU/@IPUStartTime", row));
		end =
		    Double.parseDouble(resultTab.getHiddenAttribute("IPU/@IPUEndTime", row));
	    }
	catch(java.lang.NumberFormatException ne)
	    {
		logger.error("playSelectedRow - start/end number format exception");
		return;
	    }
	
	playU.play(wavFilename, (long)(start*1000), (long)(end*1000));
    }

    private String about()
    {
	String qizxVersion = new QizxOpen().getVersion();
	String taminoClientVersion = new Client().getVersion();
	return "Ankou " + VERSION
	    + "\n Copyright (C) 2004 Teru KAMOGASHIRA. All rights reserved."
	    + "\nCopyright (C) 2000-2004 The Apache Software Foundation. All rights reserved.\n"
	    + "This product includes software developed by the\n"
	    + "Apache Software Foundation (http://www.apache.org/)."
	    + "\n[Environment]"
	    + "\nOS:" + System.getProperty("os.name") + " "
	    + System.getProperty("os.version") + " Java Virtual Machine:" + " " 
	    + System.getProperty("java.version") + " "
	    + "\n[QueryDriver]"
	    + "\nQizx/Open:" + qizxVersion
	    + "\nTaminoAPI4J:" + taminoClientVersion;
    }
    
    /**
     * ˥塼ưޤ
     */    
    public void actionPerformed(ActionEvent e)
    {
	String action = e.getActionCommand();
	if (action.equals("About"))
	    {
		JOptionPane.showMessageDialog(getContentPane(), about());
	    }
	else if (action.equals("playSelectedRow"))
	    {
		playSelectedRow(resultTab.table.getSelectedRow());
	    }
	else if (action.equals("openSelectedRowInMnfc"))
	    {
		openSelectedRowInMnfc(resultTab.table.getSelectedRow());
	    }
	// ե븡Tamino
	else if (action.equals("ConfigureDest"))
	    {
		dest.toggleDialog();
		return ;
	    }
	else if (action.equals("Exit"))
	    {
		int value =
		    JOptionPane.showConfirmDialog(getContentPane(),
						  "⤦λǤ",
						  "exit",
						  JOptionPane.YES_NO_OPTION);
		
		if (value == JOptionPane.YES_OPTION)
		    {
			System.exit(0);
		    }
		else
		    ;
	    }
	else if (action.equals("Submit"))
	    {
		submit();
	    }
	else if (action.equals("saveConfig"))
	    {
		try
		    {
			TreeDOM treeDOM = new TreeDOM();
			// Node list
			Vector v = new Vector();
			// type list (UIElement, UISelect)
			Vector v2 = new Vector();
			// place list
			Vector v3 = new Vector();
			for (int i = 0;i < elementList.size();i ++)
			    {
				v.add(((UIElement)elementList.get(i)).toNode());
				v2.add("UIElement");
				v3.add(((UIElement)elementList.get(i)).depth +
				       "," + ((UIElement)elementList.get(i)).number);
				v.add(((UISelect)selectList.get(i)).toNode());
				v2.add("UISelect");
				v3.add(((UISelect)selectList.get(i)).depth +
				       "," + ((UISelect)selectList.get(i)).number);
			    }
			IOFile.saveConfig(dest.getConfigAsVector(), v, v2, v3, this);
		    }
		catch (Exception f)
		    {
			JOptionPane.showMessageDialog(getContentPane(), "Ƥ¸˼Ԥޤ\n" +  f + "\n");
		    }
	    }
	else if (action.equals("loadConfig"))
	    {
		Vector configV = null;
		try
		    {
			configV = IOFile.loadConfig(this);
			dest.loadConfigFromVector((Vector)configV.get(0));
			//
			Vector v = (Vector)configV.get(1);
			// type
			Vector v2 = (Vector)configV.get(2);
			// place
			Vector v3 = (Vector)configV.get(3);
			for (int i = 0;i < v.size();i ++)
			    {
				int[] ret = loader.getElementPlace(((String)v3.get(i)));
				if (((String)v2.get(i)).equals("UIElement"))
				    {
					elementMatrix[ret[0]][ret[1]].loadNode((org.w3c.dom.Node)v.get(i));
				    }
				else if (((String)v2.get(i)).equals("UISelect"))
				    {
					selectMatrix[ret[0]][ret[1]].loadNode((org.w3c.dom.Node)v.get(i));
				    }
			    }
		    }
		catch (Exception f)
		    {
			JOptionPane.showMessageDialog(getContentPane(), "Ƥɤ߹ߤ˼Ԥޤ\n" +  f + "\n");
		    }
	    }
	else if (action.equals("saveOutputAsXML"))
	    {
		try
		    {
			IOFile.outputFileFromString(driver.getResultString(), this);
		    }
		catch (Exception f)
		    {
			JOptionPane.showMessageDialog(getContentPane(),
						      "¸˼Ԥޤ\nե̾å뤫̤¸ߤ뤫åƲ\n" +  f + "\n");
		    }
	    }
	else if (action.equals("saveOutputAsCSV"))
	    { 
		try
		    {
			IOFile.outputFileFromTable(resultTab.model, this, ",");
		    }
		catch (Exception f)
		    {
			JOptionPane.showMessageDialog(getContentPane(),
						      "¸˼Ԥޤ\nե̾å뤫̤¸ߤ뤫åƲ\n" + f + "\n");
		    }
	    }
	else
	    ;
    }

    /**
     * Threadƻ뤹륿ޡ
     */
    private Timer timer;
    
    /**
     * Qizx/Open饤֥ꡣ
     * static: Ƥʤȥ饤֥꤬äȤޤ˥
     * ĤQueryΤӤnew QizxOpenƤ
     * ˤĤ8Mbytes餤ĥ꡼??
     */
    private static QizxOpen qizx;
    
    /**
     * Client饤֥ꡣ
     */
    private static Client taminoClient;

    /**
     * QueryWindow
     */
    private static UIQuery query;
    
    private static QueryDriver driver;
    
    /**
     * QueryThreadΩ夲Ԥʤޤ
     * աΤʤnewϻȤʤȡ
     * ꡼ǽޤ
     */
    public void submit()
    {
	boolean startTimer = false;
	// θΥ֥Ȥ
	// GCоݤˤʤȦ
	qizx = new QizxOpen();
	taminoClient = new Client();
	
	logger.debug("submit - entering ");
	
	logger.info("submit - memory information\nFreeMemory: " +
		    Runtime.getRuntime().freeMemory() +
		    "\n TotalMemory: " +
		    Runtime.getRuntime().totalMemory() +
		    "\n Used(Total-Free):" + 
		    (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) + "\n");
	
	// UIDestоݤȤʤե̾Tamino̾
	// Vector
	Vector docs = dest.getDocVector();
	Vector taminos = dest.getTaminoVector();
	
	// 󤹤뤿ömessageõ
	String textimage = message.getText();
	message.replaceRange(null, 0, textimage.length());
	
	message.append("򳫻Ϥޤ\nե븡оݤ" + docs.size() + "ĤǤ\n");
	message.append("Taminoоݤ" + taminos.size() + "ĤǤ\n");
	
	// Compile each Element Tree into separate XQuery
	// ex.
	// for $Talk in input()/Talk
	// where $Talk/@TakID = 20
	//   for ....
	
	String qizxOpenQueryString = "";

	// first, build Qizx/Open XQuery header.
	if (docs.size() != 0)
	    {
		String docString = "", docsString = "";
		for (int i = 0;i < docs.size();i ++)
		    {
			docString = docString + "doc(\"file:///" + dest.getFilename(docs.get(i).toString()) + "\")";
			docsString = docsString + "\t\"" + dest.getFilename(docs.get(i).toString()) + "\"";
			if (i != docs.size()-1)
			    {
				docString = docString + ",\n";
				docsString = docsString + ",\n";
			    }
		    }
		
		qizxOpenQueryString = "<result>{\nlet $docs := (\n" + docString + 
		    ")\nlet $docnames := (\n" + docsString +
		    ")\nfor $doc in $docs\nfor $name in $docnames\nreturn\n" +
		    QueryCompiler.buildXQueryString(docStructNode, elementMatrix, selectMatrix, "$docs", 0,
						    "<DOC hidden=\"yes\" name=\"{$name}\"> </DOC>\n" +
						    "<IPU hidden=\"yes\"> {$IPU/@IPUID} </IPU>\n" +
						    "<IPU hidden=\"yes\"> {$IPU/@IPUStartTime} </IPU>\n" +
						    "<IPU hidden=\"yes\"> {$IPU/@IPUEndTime} </IPU>\n") +
		    "}</result>\n";
		
		message.append(qizxOpenQueryString);
		qizx.registerQuery(qizxOpenQueryString);
		qizx.start();
		query.setDocLabel("");
		startTimer = true;
		driver = qizx;
	    }
	
	// taminoϰĤݡȤʤ
	for (int i = 0;i < taminos.size();i ++)
	    {
		message.append(taminos.get(i).toString() + "\n");
		String taminoQueryString = "";
		taminoQueryString = "<result>{" +
		    QueryCompiler.buildXQueryString(docStructNode, elementMatrix, selectMatrix, "input()", 1,
						    "<IPU hidden=\"yes\"> {$IPU/@IPUID} </IPU>\n" +
						    "<IPU hidden=\"yes\"> {$IPU/@IPUStartTime} </IPU>\n" +
						    "<IPU hidden=\"yes\"> {$IPU/@IPUEndTime} </IPU>\n") +
		    "}</result>\n";
		try
		    {
			taminoClient.registerDBAndCollectionName(taminos.get(i).toString());
		    }
		catch (IllegalArgumentException e)
		    {
			JOptionPane.showMessageDialog(getContentPane(),
						      "Tamino URI 顼.\nTaminoꤹϡ\ndatabaseuri?collection̾\nϤƲ\n㡧http://taminoserver/tamino/base1219?IPUCollection");
			continue ;
		    }
		message.append(taminoQueryString);
		taminoClient.registerQuery(taminoQueryString);
		taminoClient.start();		
		query.setTaminoLabel("");
		startTimer = true;
		driver = taminoClient;
	    }
	
	if (startTimer)
	    {
		query.registerThread(qizx, taminoClient);
		// ThreadʣΩ夲ʤ褦ˤ
		item42.setEnabled(false);
		// WINDOW򳫤
		query.open();
		/*
		 * ThreadΩ夲ȤȤ
		 * θThreadƻ뤹륿ޤΩ夲ޤ
		 */
		// ΥޤϤGCƤΤʡ̵Ǥ⡼ɡ
		timer = new Timer(500, new ActionListener()
		    {
			public void actionPerformed(ActionEvent evt)
			{
			    logger.debug("Entering actionPerformed in Timer");
			    try
				{
				    logger.debug("Timer - testing thread");
				    if (!driver.isAlive())
					{
					    logger.debug("Timer - join thread");
					    
					    driver.join();
					    query.setDocLabel("̤");
					    
					    // ⤷
					    if (driver.checkResult())
						{
						    logger.debug("Timer - search -> success");
						    logger.debug(driver.getResultString());
						    resultTab.registerResults(driver.getResultString());
						}
					    // 
					    else
						{
						    logger.debug("Timer - search -> failed");
						    JOptionPane.showMessageDialog(getContentPane(),
										  "˼Ԥޤ\n" + 
										  driver.getExceptionString());
						    message.append(driver.getExceptionString());
						}
					    
					    query.close();
					    
					    // ¹ԤǤ褦ˤ
					    item42.setEnabled(true);
					    
					    logger.debug("submit - stopping Timer");
					    // ޤѺѤ
					    timer.stop();
					    
					    // ޤ̣ʤ
					    System.gc();
					}
				}
			    catch (InterruptedException e)
				{
				    logger.debug("submit - interrupt");
				    // 
				    query.setDocLabel("");	
				    JOptionPane.showMessageDialog(getContentPane(),
								  "Ǥޤ\n" + 
								  driver.getExceptionString());
				    message.append(driver.getExceptionString());
				    //
				    e.printStackTrace();
				}
			    catch (Exception e)
				{
				    logger.debug("submit - Exception from qizx");
				    message.append(e.toString());
				    //
				    e.printStackTrace();
				    query.close();
				    
				    // ¹ԤǤ褦ˤ
				    item42.setEnabled(true);
				    
				    logger.debug("submit - stopping Timer");
				    // ޤѺѤ
				    timer.stop();
				    
				    // ޤ̣ʤ
				    System.gc();
				}
			    catch (java.lang.OutOfMemoryError e)
				{
				    logger.error("submit - java.lang.OutOfMemoryError");
				    JOptionPane.showMessageDialog(getContentPane(),
								  "꤬­ޤ󡣸оݤ򸺤餹ʤɤơ̤򸺤餷Ʋ\njava -Xms256M -Xmx256M ...ʤɤJavaVMۥ̤䤷Ƥ⤤⤷ޤ");
				    query.close();
				    
				    // ¹ԤǤ褦ˤ
				    item42.setEnabled(true);
				    
				    logger.debug("submit - stopping Timer");
				    // ޤѺѤ
				    timer.stop();
				    
				    // ޤ̣ʤ
				    System.gc();
				}
			    
			    logger.debug("Exiting actionPerformed in Timer");
			    return ;
			    
			}
			
		    });
		
		// 󥹥ȡ뤷饿ޤ¹
		logger.debug("submit - Starting Timer");
		timer.start();
	    }
	
	logger.debug("submit - exiting");
	// exit to UI
	// ʤSWINGʤ(ޤ)
	return ;
    }
    
    /**
     * ưŪ˥ƥȤΰֺǸޤǥ뤷ޤ
     * @param text 뤹JTextArea
     */
    public void autoScroll(JTextArea text)
    {
	Document doc    = text.getDocument();
	Position endPos = doc.getEndPosition();
	int pos         = endPos.getOffset();
	text.getCaret().setDot(pos);
	text.requestFocus();
    }
    
    private static final void showSplash(Frame owner)
    {
	splash = new AnkouSplash(owner);
	AnkouSplash.centerOnScreen(splash);
	splash.setVisible(true);
    }
    
    private static final void removeSplash()
    {
	if (splash != null)
	    {
		splash.setVisible(false);
		splash.dispose();
	    }
    }
    
    /**
     * ץ२ȥݥ
     * @param args ޥɥ饤ξܺ٤ϥ饹򻲾ȤƲ
     */
    public static void main(String[] args)
    {
	// Log4j ʰ
	BasicConfigurator.configure();
	
	// SplashΤˤäJFrameѰ
	JFrame sp = new JFrame();
	showSplash(sp);
	
	logger.debug("main - entering");
	logger.info("main - OS: "+System.getProperty("os.name"));
	logger.info("main - OS version: "+System.getProperty("os.version"));
	logger.info("main - JRE: "+System.getProperty("java.version"));

	// 줬ɽǤʤۤɸŤJava⤢뤬
	// ̵(plain AWT )
	if (System.getProperty("java.version").compareTo(REQUIRED_VERSION) < 0)
	    {
		removeSplash();
		JOptionPane.showMessageDialog(sp,
					      "Java Virtual MachineΥС󤬸ŤΤ\nưʤǽޤ\nưߤޤʤɤޤʤǽΤǥޥ˥奢˽ä\nJava Virtual Machine򥤥󥹥ȡ뤷Ʋ");
	    }
	
	client = new Client();
	resultTab = new CompileResults();
	playU = new UIPlay();
	query = new UIQuery();
	
	app = new TaminoClient();

	dest = new UIDestSelect();

	// Place window at the center.
	Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
	Dimension frameSize = app.getSize();
	if (frameSize.height > screenSize.height)
	    {
		frameSize.height = screenSize.height;
	    }
	if (frameSize.width > screenSize.width)
	    {
		frameSize.width = screenSize.width;
	    }
	app.setLocation((screenSize.width - frameSize.width) / 2,
			(screenSize.height - frameSize.height) / 2);
	removeSplash();
	app.setVisible(true);
    }
}
