// very simple JTree <-> DOM converter
// Copyright (C) 2004 Teru KAMOGASHIRA

package jp.go.kokken.Ankou;

import java.io.*;
import javax.swing.tree.*;
import org.w3c.dom.*;
import javax.xml.parsers.*;

import javax.xml.transform.*;
import javax.xml.transform.dom.*;
import javax.xml.transform.stream.*;

/**
   JTreeݻƤconvert javax.swing.tree.DefaultMutableTreeNode
   ¸ɤ߹ߤǤ褦ˤ뤿org.w3c.dom.ElementȤѴ
   ΤΥ饹
   
   㤨СʲΤ褦JTreeϲΤ褦DOMѴޤ
   
   <ul>
   <li>root</li>
   <ul>
   <li>a</li>
   <li>b</li>
   </ul>
   </ul>

   <pre>
   &lt;?xml version=&quot;1.0&quot; encoding=&quot;utf-8&quot;?&gt;
   &lt;TreeNode tag=&quot;root&quot;&gt;
   &lt;TreeNode tag=&quot;a&quot;/&gt;
   &lt;TreeNode tag=&quot;b&quot;/&gt;
   &lt;/TreeNode&gt;
   </pre>

   ޤDOMΤ褦DefaultMutaleTreeNodeǤޤ
   tag̾°̾ϥ󥹥ȥ饯ǽǤ
 */

public class TreeDOM
{
    private String attrName = null;
    private String tagName = null;
   
    TreeDOM()
    {
	this("tag", "TreeNode");
    }
 
    TreeDOM(String attr, String tag)
    {
	attrName = attr;
	tagName = tag;
    }

    /**
     * nodeDefaultMutabletTreeNode̤ꡣ
     *
     * @param node DOMNode
     */
    public DefaultMutableTreeNode nodeToTreeNode(Node node)
    {
	DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode();
	
	NamedNodeMap map = node.getAttributes();
	if (map == null)
	    return null;
	Node n = map.getNamedItem(attrName);
	if (n == null)
	    return null;
	treeNode.setUserObject(n.getNodeValue());
	
	if (node.hasChildNodes())
	    {
		NodeList nodeList = node.getChildNodes();
		for (int i = 0;i < nodeList.getLength();i ++)
		    {
			DefaultMutableTreeNode childTreeNode = nodeToTreeNode(nodeList.item(i));
			if (childTreeNode != null)
			    {
				treeNode.add(childTreeNode);
			    }
		    }
	    }
	
	return treeNode;
    }

    /**
     * DefaultMutableTreeNodeDOMElement
     *
     * @param treeNode Ѵ
     */
    public Element treeNodeToNode(DefaultMutableTreeNode treeNode)
    {
	Document document = null;
	try
	    {
		// DOM 
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance(); 
		DocumentBuilder builder = factory.newDocumentBuilder(); 
		DOMImplementation domImpl = builder.getDOMImplementation();
		document = domImpl.createDocument("", tagName, null);
	    }
	// ä麤롣
	catch (javax.xml.parsers.ParserConfigurationException e)
	    {
		return null;
	    }
	Element el = treeNodeToNode(treeNode, document, document.getDocumentElement());
	return (Element)el.getFirstChild();
    }
    
    /**
     * ƵδؿdocumentNodeäꡢ­ꤹΤǡä
     * ¿ᡣ(;Ϥꡣ)
     *
     * @param treeNode Ѵ٤ĤäƤҤɤnode
     * @param document Node, Attr
     * @param node Ҥɤ­current node
     */
    private Element treeNodeToNode(DefaultMutableTreeNode treeNode, Document document, Element node)
    {
	Element tagNode = document.createElement(tagName);
	Attr attr = document.createAttribute(attrName);
	attr.setValue((String)treeNode.getUserObject());
	
	tagNode.setAttributeNode(attr);
	
	node.appendChild(tagNode);

	if (!treeNode.isLeaf())
	    {
		for (int i = 0;i < treeNode.getChildCount();i ++)
		    {
			DefaultMutableTreeNode childTreeNode =
			    (DefaultMutableTreeNode)treeNode.getChildAt(i);
			Element n = null;
			if (childTreeNode != null)
			    {
				// ƵääTree򰷤ϡ
				n = treeNodeToNode(childTreeNode, document, tagNode);
			    }
		    }
	    }

	return node;
    }
}
